/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items;

import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.BaseToggleableTool;
import com.direwolf20.justdirethings.common.items.interfaces.FluidContainingItem;
import com.direwolf20.justdirethings.common.items.interfaces.LeftClickableTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.util.MagicHelpers;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class PolymorphicWand
extends BaseToggleableTool
implements LeftClickableTool,
FluidContainingItem {
    public PolymorphicWand() {
        super(new Item.Properties().fireResistant().durability(200));
        this.registerAbility(Ability.LAVAREPAIR);
        this.registerAbility(Ability.POLYMORPH_RANDOM);
    }

    @Override
    public int getMaxMB() {
        return (Integer)Config.POLYMORPHIC_WAND_MAX_FLUID.get();
    }

    @Override
    public InteractionResult useOn(UseOnContext pContext) {
        ItemStack itemStack = pContext.getItemInHand();
        Player player = pContext.getPlayer();
        if (player == null || itemStack.isEmpty()) {
            return InteractionResult.FAIL;
        }
        BlockHitResult blockhitresult = PolymorphicWand.getPlayerPOVHitResult((Level)player.level(), (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.getType() == HitResult.Type.BLOCK && FluidContainingItem.pickupFluid(player.level(), player, itemStack, blockhitresult)) {
            return InteractionResult.SUCCESS;
        }
        return super.useOn(pContext);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        Level level = player.level();
        if (level.isClientSide) {
            return true;
        }
        ItemStack itemStack = player.getMainHandItem();
        Set<Ability> abilities = LeftClickableTool.getLeftClickList(itemStack);
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool) {
            ToggleableTool toggleableTool = (ToggleableTool)item;
            if (!abilities.isEmpty()) {
                toggleableTool.useAbility(player.level(), player, InteractionHand.MAIN_HAND, false);
            }
        }
        return true;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        BlockHitResult blockhitresult = PolymorphicWand.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.getType() == HitResult.Type.BLOCK && FluidContainingItem.pickupFluid(level, player, itemStack, blockhitresult)) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        return super.use(level, player, hand);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Level level = context.level();
        if (level == null) {
            return;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return;
        }
        tooltip.add((Component)Component.translatable((String)"justdirethings.polymorphicfluidamt", (Object[])new Object[]{MagicHelpers.formatted(fluidHandler.getFluidInTank(0).getAmount()), MagicHelpers.formatted(fluidHandler.getTankCapacity(0))}).withStyle(ChatFormatting.GREEN));
    }
}

