/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.util;

import com.direwolf20.justdirethings.datagen.JustDireBlockTags;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MiscTools {
    public static void doExtraTicks(ServerLevel serverLevel, BlockPos blockPos, double rate) {
        BlockEntity blockEntity;
        BlockState blockState = serverLevel.getBlockState(blockPos);
        if (!MiscTools.isValidTickAccelBlock(serverLevel, blockState, blockEntity = serverLevel.getBlockEntity(blockPos))) {
            return;
        }
        int i = 0;
        while ((double)i < rate) {
            if (blockEntity != null) {
                BlockEntityTicker ticker = blockEntity.getBlockState().getTicker((Level)serverLevel, blockEntity.getType());
                if (ticker != null) {
                    ticker.tick((Level)serverLevel, blockPos, blockEntity.getBlockState(), blockEntity);
                }
            } else if (blockState.isRandomlyTicking() && serverLevel.random.nextInt(1365) == 0) {
                blockState.randomTick(serverLevel, blockPos, serverLevel.random);
            }
            ++i;
        }
    }

    public static boolean isValidTickAccelBlock(ServerLevel serverLevel, BlockState blockState, BlockEntity blockEntity) {
        BlockEntityTicker ticker;
        if (blockEntity == null && !blockState.isRandomlyTicking()) {
            return false;
        }
        if (blockEntity != null && (ticker = blockEntity.getBlockState().getTicker((Level)serverLevel, blockEntity.getType())) == null) {
            return false;
        }
        return !blockState.is(JustDireBlockTags.TICK_SPEED_DENY);
    }

    @NotNull
    public static BlockHitResult getHitResult(Player player) {
        Vec3 playerLook = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
        Vec3 lookVec = player.getViewVector(1.0f);
        double reach = player.blockInteractionRange();
        Vec3 endLook = playerLook.add(lookVec.x * reach, lookVec.y * reach, lookVec.z * reach);
        BlockHitResult hitResult = player.level().clip(new ClipContext(playerLook, endLook, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        return hitResult;
    }

    public static Entity getEntityLookedAt(Player player, double maxDistance) {
        EntityHitResult entityHitResult;
        Vec3 eyePosition = player.getEyePosition(1.0f);
        Vec3 lookVector = player.getViewVector(1.0f).scale(maxDistance);
        Vec3 endPosition = eyePosition.add(lookVector);
        BlockHitResult hitResult = player.level().clip(new ClipContext(eyePosition, endPosition, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (hitResult.getType() != HitResult.Type.MISS) {
            endPosition = hitResult.getLocation();
        }
        if ((entityHitResult = MiscTools.rayTraceEntities(player, eyePosition, endPosition, player.getBoundingBox().expandTowards(lookVector).inflate(1.0, 1.0, 1.0), maxDistance)) != null) {
            return entityHitResult.getEntity();
        }
        return null;
    }

    private static EntityHitResult rayTraceEntities(Player player, Vec3 start, Vec3 end, AABB boundingBox, double maxDistance) {
        double closestDistance = maxDistance;
        Entity closestEntity = null;
        Vec3 hitLocation = null;
        for (Entity entity : player.level().getEntities((Entity)player, boundingBox, e -> e != player && e.isPickable())) {
            Vec3 hitVec;
            double distanceToHitVec;
            AABB entityBoundingBox = entity.getBoundingBox().inflate((double)entity.getPickRadius());
            Optional optHitVec = entityBoundingBox.clip(start, end);
            if (entityBoundingBox.contains(start)) {
                if (!(closestDistance >= 0.0)) continue;
                closestEntity = entity;
                hitLocation = optHitVec.orElse(start);
                closestDistance = 0.0;
                continue;
            }
            if (!optHitVec.isPresent() || !((distanceToHitVec = start.distanceTo(hitVec = (Vec3)optHitVec.get())) < closestDistance) && closestDistance != 0.0) continue;
            if (entity.getRootVehicle() == player.getRootVehicle() && !entity.canRiderInteract()) {
                if (closestDistance != 0.0) continue;
                closestEntity = entity;
                hitLocation = hitVec;
                continue;
            }
            closestEntity = entity;
            hitLocation = hitVec;
            closestDistance = distanceToHitVec;
        }
        return closestEntity == null ? null : new EntityHitResult(closestEntity, hitLocation);
    }

    public static boolean inBounds(int x, int y, int w, int h, double ox, double oy) {
        return ox >= (double)x && ox <= (double)(x + w) && oy >= (double)y && oy <= (double)(y + h);
    }

    public static Vector3f findOffset(Direction direction, int slot, Vector3f[] offsets) {
        Vector3f offsetVector = new Vector3f((Vector3fc)offsets[slot]);
        switch (direction) {
            case UP: {
                Quaternionf quaternionf = Axis.XP.rotationDegrees(-270.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(0.0f, 1.0f, 0.0f);
                break;
            }
            case DOWN: {
                Quaternionf quaternionf = Axis.XP.rotationDegrees(-90.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(0.0f, 0.0f, 1.0f);
                break;
            }
            case EAST: {
                Quaternionf quaternionf = Axis.YP.rotationDegrees(-90.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(1.0f, 0.0f, 0.0f);
                break;
            }
            case SOUTH: {
                Quaternionf quaternionf = Axis.YP.rotationDegrees(-180.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(1.0f, 0.0f, 1.0f);
                break;
            }
            case WEST: {
                Quaternionf quaternionf = Axis.YP.rotationDegrees(-270.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(0.0f, 0.0f, 1.0f);
            }
        }
        return offsetVector;
    }

    public static ListTag stringListToNBT(List<String> list) {
        ListTag nbtList = new ListTag();
        for (String string : list) {
            CompoundTag tag = new CompoundTag();
            tag.putString("list", string);
            nbtList.add((Object)tag);
        }
        return nbtList;
    }

    public static List<String> NBTToStringList(ListTag nbtList) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag tag = nbtList.getCompound(i);
            list.add(tag.getString("list"));
        }
        return list;
    }

    public static MutableComponent tooltipMaker(String string, int color) {
        Style style = Style.EMPTY;
        style = style.withColor(color);
        MutableComponent current = Component.translatable((String)string);
        current.setStyle(style);
        return current;
    }
}

