/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.datagen;

import com.github.bigenergy.glassential.Glassential;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public final class GlassentialTags {
    private GlassentialTags() {
    }

    public static class Fluids {
        public static final TagKey<Fluid> CLEAR_FLUID_GLASS_FLUIDS_TAG = Fluids.tag("clear_fluid_glass_fluids");

        private static TagKey<Fluid> tag(String name) {
            return FluidTags.create((ResourceLocation)Glassential.prefix(name));
        }
    }

    public static final class Items {
        public static final TagKey<Item> DOORS_DYED = Items.itag("doors/dyed");
        public static final Map<DyeColor, TagKey<Item>> DOORS_DYED_BY_COLOR = Items.icolored("doors/dyed/");
        public static final TagKey<Item> TRAPDOORS_DYED = Items.itag("trapdoors/dyed");
        public static final Map<DyeColor, TagKey<Item>> TRAPDOORS_DYED_BY_COLOR = Items.icolored("trapdoors/dyed/");

        private static TagKey<Item> itag(String path) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"glassential", (String)path));
        }

        private static Map<DyeColor, TagKey<Item>> icolored(String base) {
            EnumMap<DyeColor, TagKey<Item>> map = new EnumMap<DyeColor, TagKey<Item>>(DyeColor.class);
            Arrays.stream(DyeColor.values()).forEach(c -> map.put((DyeColor)c, Items.itag(base + c.getName())));
            return map;
        }
    }

    public static final class Blocks {
        public static final TagKey<Block> DOORS_DYED = Blocks.tag("doors/dyed");
        public static final Map<DyeColor, TagKey<Block>> DOORS_DYED_BY_COLOR = Blocks.colored("doors/dyed/");
        public static final TagKey<Block> TRAPDOORS_DYED = Blocks.tag("trapdoors/dyed");
        public static final Map<DyeColor, TagKey<Block>> TRAPDOORS_DYED_BY_COLOR = Blocks.colored("trapdoors/dyed/");

        private static TagKey<Block> tag(String path) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"glassential", (String)path));
        }

        private static Map<DyeColor, TagKey<Block>> colored(String base) {
            EnumMap<DyeColor, TagKey<Block>> map = new EnumMap<DyeColor, TagKey<Block>>(DyeColor.class);
            Arrays.stream(DyeColor.values()).forEach(c -> map.put((DyeColor)c, Blocks.tag(base + c.getName())));
            return map;
        }
    }
}

