/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model.predicates;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicate;
import net.minecraft.world.entity.Entity;

public class AltitudeEntityModelPredicate
implements EntityModelPredicate {
    public static final Serializer<AltitudeEntityModelPredicate> SERIALIZER = new Serializer<AltitudeEntityModelPredicate>(){

        @Override
        public AltitudeEntityModelPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!json.has("min_height") && !json.has("max_height")) {
                throw new JsonParseException("Altitude-predicate must have at least one of 'min_height' or 'max_height'!");
            }
            int min = Integer.MIN_VALUE;
            if (json.has("min_height")) {
                if (!json.get("min_height").isJsonPrimitive() || !json.getAsJsonPrimitive("min_height").isNumber()) {
                    throw new JsonParseException("Property 'min_height' must be a number!");
                }
                min = json.getAsJsonPrimitive("min_height").getAsInt();
            }
            int max = Integer.MAX_VALUE;
            if (json.has("max_height")) {
                if (!json.get("max_height").isJsonPrimitive() || !json.getAsJsonPrimitive("max_height").isNumber()) {
                    throw new JsonParseException("Property 'max_height' must be a number!");
                }
                max = json.getAsJsonPrimitive("max_height").getAsInt();
            }
            if (min > max) {
                throw new JsonParseException("Minimum height must be less than or equal to maximum height!");
            }
            return new AltitudeEntityModelPredicate(min, max);
        }

        @Override
        public JsonObject serialize(AltitudeEntityModelPredicate value) {
            JsonObject json = new JsonObject();
            if (value.min != Integer.MIN_VALUE) {
                json.addProperty("min_height", (Number)value.min);
            }
            if (value.max != Integer.MAX_VALUE) {
                json.addProperty("max_height", (Number)value.max);
            }
            return json;
        }
    };
    private final int min;
    private final int max;

    public AltitudeEntityModelPredicate(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean test(Entity entity) {
        int height = entity.blockPosition().getY();
        return this.min <= height && this.max >= height;
    }

    @Override
    public Serializer<? extends EntityModelPredicate> getSerializer() {
        return SERIALIZER;
    }
}

