/*
 * Decompiled with CFR 0.152.
 */
package tfar.metalbarrels;

import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tfar.metalbarrels.init.ModBlockEntityTypes;
import tfar.metalbarrels.init.ModBlocks;
import tfar.metalbarrels.init.ModCreativeTabs;
import tfar.metalbarrels.init.ModItems;
import tfar.metalbarrels.init.ModMenuTypes;
import tfar.metalbarrels.item.BarrelUpgradeItem;
import tfar.metalbarrels.platform.Services;

public class MetalBarrels {
    public static final String MOD_ID = "metalbarrels";
    public static final String MOD_NAME = "MetalBarrels";
    public static final Logger LOG = LoggerFactory.getLogger((String)"MetalBarrels");
    public static final String[] tiers = new String[]{"wood", "copper", "iron", "silver", "gold", "diamond", "obsidian", "netherite"};

    public static void init() {
        Services.PLATFORM.registerAll(ModBlocks.class, BuiltInRegistries.BLOCK, Block.class);
        Services.PLATFORM.registerAll(ModBlockEntityTypes.class, BuiltInRegistries.BLOCK_ENTITY_TYPE, BlockEntityType.class);
        Services.PLATFORM.registerAll(ModMenuTypes.class, BuiltInRegistries.MENU, MenuType.class);
        Services.PLATFORM.registerAll(ModCreativeTabs.class, BuiltInRegistries.CREATIVE_MODE_TAB, CreativeModeTab.class);
        Services.PLATFORM.registerAll(ModItems.class, BuiltInRegistries.ITEM, Item.class);
        for (Map.Entry<String, BarrelUpgradeItem> entry : ModItems.upgrade_items.entrySet()) {
            Services.PLATFORM.register(BuiltInRegistries.ITEM, (Item)entry.getValue(), MetalBarrels.id(entry.getKey()));
        }
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

