/*
 * Decompiled with CFR 0.152.
 */
package tfar.metalbarrels.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import tfar.metalbarrels.block.MetalBarrelBlock;
import tfar.metalbarrels.menu.MetalBarrelMenu;
import tfar.metalbarrels.util.BarrelHandler;
import tfar.metalbarrels.util.BarrelProperties;

public abstract class MetalBarrelBlockEntity<H extends BarrelHandler>
extends BlockEntity
implements MenuProvider,
Nameable {
    protected final BarrelProperties barrelProperties;
    protected Component customName;
    public H barrelHandler;
    public final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            MetalBarrelBlockEntity.this.playSound(state, SoundEvents.BARREL_OPEN);
            MetalBarrelBlockEntity.this.updateBlockState(state, true);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            MetalBarrelBlockEntity.this.playSound(state, SoundEvents.BARREL_CLOSE);
            MetalBarrelBlockEntity.this.updateBlockState(state, false);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int previousCount, int newCount) {
        }

        protected boolean isOwnContainer(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof MetalBarrelMenu) {
                MetalBarrelMenu metalBarrelMenu = (MetalBarrelMenu)abstractContainerMenu;
                Object handler1 = metalBarrelMenu.handler;
                return handler1 == MetalBarrelBlockEntity.this.barrelHandler;
            }
            return false;
        }
    };

    public MetalBarrelBlockEntity(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
        this.barrelProperties = this.getPropertiesFromState(state);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider levelRegistry) {
        CompoundTag compound = this.barrelHandler.$serialize(levelRegistry);
        tag.put("inv", (Tag)compound);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)levelRegistry));
        }
        super.saveAdditional(tag, levelRegistry);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider levelRegistry) {
        CompoundTag invTag = tag.getCompound("inv");
        this.barrelHandler.$deserialize(invTag, levelRegistry);
        if (tag.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)levelRegistry);
        }
        super.loadAdditional(tag, levelRegistry);
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public Component getCustomName() {
        return this.customName;
    }

    void updateBlockState(BlockState pState, boolean pOpen) {
        this.level.setBlock(this.getBlockPos(), (BlockState)pState.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(pOpen)), 3);
    }

    void playSound(BlockState pState, SoundEvent pSound) {
        Vec3i vec3i = ((Direction)pState.getValue((Property)BarrelBlock.FACING)).getNormal();
        double d0 = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double d1 = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound(null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    public void startOpen(Player pPlayer) {
        if (!this.isRemoved() && !pPlayer.isSpectator()) {
            this.openersCounter.incrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player pPlayer) {
        if (!this.isRemoved() && !pPlayer.isSpectator()) {
            this.openersCounter.decrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.isRemoved()) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public abstract int calculateRedstone();

    protected Component getDefaultName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return this.barrelProperties.barrelMenuFactory().create(id, inv, (BarrelHandler)this.barrelHandler);
    }

    public BarrelProperties getPropertiesFromState(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof MetalBarrelBlock) {
            MetalBarrelBlock metalBarrelBlock = (MetalBarrelBlock)block;
            return metalBarrelBlock.getBarrelProperties();
        }
        return null;
    }
}

