/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.neoforge.loader;

import java.util.function.Supplier;
import me.lucko.luckperms.common.loader.JarInJarClassLoader;
import me.lucko.luckperms.common.loader.LoaderBootstrap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="luckperms")
public class NeoForgeLoaderPlugin
implements Supplier<ModContainer> {
    private static final Logger LOGGER = LogManager.getLogger((String)"luckperms");
    private static final String JAR_NAME = "luckperms-neoforge.jarinjar";
    private static final String BOOTSTRAP_CLASS = "me.lucko.luckperms.neoforge.LPNeoForgeBootstrap";
    private final ModContainer container;
    private JarInJarClassLoader loader;
    private LoaderBootstrap plugin;

    public NeoForgeLoaderPlugin(ModContainer modContainer, IEventBus modBus) {
        this.container = modContainer;
        if (FMLEnvironment.dist.isClient()) {
            LOGGER.info("Skipping LuckPerms init (not supported on the client!)");
            return;
        }
        this.loader = new JarInJarClassLoader(this.getClass().getClassLoader(), JAR_NAME);
        modBus.addListener(this::onCommonSetup);
    }

    @Override
    public ModContainer get() {
        return this.container;
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        this.plugin = this.loader.instantiatePlugin(BOOTSTRAP_CLASS, Supplier.class, this);
        this.plugin.onLoad();
    }
}

