/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbezcrystals;

import dev.ftb.mods.ftbezcrystals.datamap.EZDataMaps;
import dev.ftb.mods.ftbezcrystals.datamap.HarvestableCrystal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="ftbezcrystals")
public class FTBEZCrystals {
    public static final String MOD_ID = "ftbezcrystals";
    private static final Logger LOGGER = LoggerFactory.getLogger(FTBEZCrystals.class);

    public FTBEZCrystals(IEventBus eventBus, ModContainer container) {
        eventBus.addListener(EZDataMaps::register);
        NeoForge.EVENT_BUS.addListener(this::clusterInteract);
    }

    private void clusterInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() == InteractionHand.OFF_HAND) {
            return;
        }
        FTBEZCrystals.harvestCrystal(event.getLevel(), event.getPos(), event.getItemStack(), event.getEntity());
    }

    public static void harvestCrystal(Level level, BlockPos pos, ItemStack heldStack, Player player) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        HarvestableCrystal harvestableCrystal = (HarvestableCrystal)block.builtInRegistryHolder().getData(EZDataMaps.HARVESTABLE_CRYSTALS);
        if (harvestableCrystal != null && state.hasProperty((Property)BlockStateProperties.FACING)) {
            Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            BlockState attachedState = level.getBlockState(pos.relative(direction.getOpposite()));
            boolean onBudding = harvestableCrystal.buddingBlocks().stream().anyMatch(arg_0 -> ((BlockState)attachedState).is(arg_0));
            if (!onBudding) {
                return;
            }
            BlockState budState = harvestableCrystal.bud().defaultBlockState();
            budState = (BlockState)budState.setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.FACING)));
            Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)heldStack);
            SoundType soundtype = state.getSoundType((LevelReader)level, pos, (Entity)player);
            level.playSound(null, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            level.setBlock(pos, budState, 3);
            ParticleUtils.spawnParticles((LevelAccessor)level, (BlockPos)pos, (int)10, (double)1.0, (double)1.0, (boolean)true, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
            player.swing(InteractionHand.MAIN_HAND, true);
        }
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

