/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.events;

import com.google.common.base.Throwables;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import invtweaks.config.ContOverride;
import invtweaks.config.InvTweaksConfig;
import invtweaks.config.Ruleset;
import invtweaks.events.KeyMappings;
import invtweaks.gui.InvTweaksButtonSort;
import invtweaks.network.PacketSortInv;
import invtweaks.util.ClientUtils;
import invtweaks.util.Sorting;
import invtweaks.util.Utils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="invtweaks", value={Dist.CLIENT})
public class ClientEvents {
    public static final int MIN_SLOTS = 9;
    private static final Set<Screen> screensWithExtSort = Collections.newSetFromMap(new WeakHashMap());
    private static BooleanSupplier isJEIKeyboardActive = () -> false;

    private ClientEvents() {
    }

    private static void requestSort(boolean isPlayer, String screenClass) {
        if (ClientUtils.serverConnectionExists()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new PacketSortInv(isPlayer, screenClass), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            Sorting.executeSort(ClientUtils.safeGetPlayer(), isPlayer, screenClass);
        }
    }

    @Nullable
    public static Slot getDefaultButtonPlacement(Collection<Slot> slots, Predicate<Slot> filter) {
        if (slots.stream().filter(filter).count() < 9L) {
            return null;
        }
        return slots.stream().filter(filter).max(Comparator.comparingInt(s -> s.x).thenComparingInt(s -> -s.y)).orElse(null);
    }

    @SubscribeEvent
    public static void onScreenEventInit(ScreenEvent.Init.Post event) {
        AbstractContainerScreen screen;
        Screen screen2 = event.getScreen();
        if (screen2 instanceof AbstractContainerScreen && !((screen = (AbstractContainerScreen)screen2) instanceof CreativeModeInventoryScreen)) {
            Slot placement = ClientEvents.getDefaultButtonPlacement((Collection<Slot>)screen.getMenu().slots, slot -> slot.container instanceof Inventory);
            if (placement != null && InvTweaksConfig.isSortEnabled(true) && InvTweaksConfig.isButtonEnabled(true)) {
                try {
                    event.addListener((GuiEventListener)new InvTweaksButtonSort(screen.getGuiLeft() + placement.x + 17, screen.getGuiTop() + placement.y, btn -> ClientEvents.requestSort(true, screen.getClass().getName())));
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            ContOverride override = InvTweaksConfig.getPlayerContOverride((Player)Minecraft.getInstance().player, screen.getClass().getName(), screen.getMenu().getClass().getName());
            boolean isSortDisabled = Optional.ofNullable(override).filter(ContOverride::isSortDisabled).isPresent();
            if (!(screen instanceof EffectRenderingInventoryScreen) && !isSortDisabled) {
                int x = -1418392593;
                int y = -1418392593;
                if (override != null) {
                    x = override.getX();
                    y = override.getY();
                }
                if ((placement = ClientEvents.getDefaultButtonPlacement((Collection<Slot>)screen.getMenu().slots, slot -> !(slot.container instanceof Inventory) && !(slot.container instanceof CraftingContainer))) != null) {
                    if (x == -1418392593) {
                        x = placement.x + 17;
                    }
                    if (y == -1418392593) {
                        y = placement.y;
                    }
                }
                if (InvTweaksConfig.isSortEnabled(false)) {
                    try {
                        if (InvTweaksConfig.isButtonEnabled(false)) {
                            event.addListener((GuiEventListener)new InvTweaksButtonSort(screen.getGuiLeft() + x, screen.getGuiTop() + y, btn -> ClientEvents.requestSort(false, screen.getClass().getName())));
                        }
                        screensWithExtSort.add((Screen)screen);
                    }
                    catch (Exception e) {
                        Throwables.throwIfUnchecked((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public static void setJEIKeyboardActiveFn(BooleanSupplier query) {
        isJEIKeyboardActive = query;
    }

    public static boolean isJEIKeyboardActive() {
        return isJEIKeyboardActive.getAsBoolean();
    }

    @SubscribeEvent
    public static void onKeyPressed(ScreenEvent.KeyPressed.Pre event) {
        AbstractContainerScreen screen;
        Screen screen2 = event.getScreen();
        if (screen2 instanceof AbstractContainerScreen && !((screen = (AbstractContainerScreen)screen2) instanceof CreativeModeInventoryScreen) && !(screen.getFocused() instanceof EditBox) && !ClientEvents.isJEIKeyboardActive()) {
            boolean isPlayerSort;
            Slot slot;
            if (InvTweaksConfig.isSortEnabled(true) && KeyMappings.SORT_PLAYER.isActiveAndMatches(InputConstants.getKey((int)event.getKeyCode(), (int)event.getScanCode()))) {
                ClientEvents.requestSort(true, screen.getClass().getName());
            }
            if (InvTweaksConfig.isSortEnabled(false) && screensWithExtSort.contains(event.getScreen()) && KeyMappings.SORT_INVENTORY.isActiveAndMatches(InputConstants.getKey((int)event.getKeyCode(), (int)event.getScanCode()))) {
                ClientEvents.requestSort(false, screen.getClass().getName());
            }
            if ((slot = screen.getSlotUnderMouse()) != null && InvTweaksConfig.isSortEnabled(isPlayerSort = Utils.isPlayerContainer(slot.container, screen, (Player)Minecraft.getInstance().player)) && (isPlayerSort || screensWithExtSort.contains(event.getScreen())) && KeyMappings.SORT_EITHER.isActiveAndMatches(InputConstants.getKey((int)event.getKeyCode(), (int)event.getScanCode()))) {
                ClientEvents.requestSort(isPlayerSort, screen.getClass().getName());
            }
        }
    }

    @SubscribeEvent
    public static void onMouseButtonPressed(ScreenEvent.MouseButtonPressed.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (!(event.getScreen() instanceof CreativeModeInventoryScreen)) {
                boolean isMouseActive;
                boolean bl = isMouseActive = KeyMappings.SORT_EITHER.getKeyConflictContext().isActive() && KeyMappings.SORT_EITHER.matchesMouse(event.getButton());
                if (!isMouseActive) {
                    return;
                }
                Slot slot = screen2.getSlotUnderMouse();
                if (slot != null) {
                    if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasInfiniteMaterials() && !slot.getItem().isEmpty()) {
                        return;
                    }
                    boolean isPlayerSort = Utils.isPlayerContainer(slot.container, screen2, (Player)Minecraft.getInstance().player);
                    if (InvTweaksConfig.isSortEnabled(isPlayerSort) && (isPlayerSort || screensWithExtSort.contains(event.getScreen()))) {
                        ClientEvents.requestSort(isPlayerSort, screen2.getClass().getName());
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGuiLayerEvent.Post event) {
        if (event.getName().equals((Object)VanillaGuiLayers.HOTBAR)) {
            LocalPlayer ent = Minecraft.getInstance().player;
            if (!InvTweaksConfig.isQuickViewEnabled()) {
                return;
            }
            Ruleset rules = InvTweaksConfig.getSelfCompiledRules();
            IntList frozen = (IntList)Optional.ofNullable(rules.catToInventorySlots("/FROZEN")).map(IntArrayList::new).orElseGet(IntArrayList::new);
            frozen.sort(null);
            assert (ent != null);
            if (Collections.binarySearch(frozen, ent.getInventory().selected) >= 0) {
                return;
            }
            HumanoidArm dominantHand = ent.getMainArm();
            int i = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2;
            int i2 = Minecraft.getInstance().getWindow().getGuiScaledHeight() - 16 - 3;
            int prime = dominantHand == HumanoidArm.RIGHT ? i + 91 + 10 : i - 91 - 26;
            int itemCount = IntStream.range(0, ent.getInventory().items.size()).filter(idx -> Collections.binarySearch(frozen, idx) < 0).mapToObj(arg_0 -> ((NonNullList)ent.getInventory().items).get(arg_0)).filter(arg_0 -> ClientEvents.lambda$renderOverlay$8((Player)ent, arg_0)).mapToInt(ItemStack::getCount).sum();
            if (itemCount > ent.getMainHandItem().getCount()) {
                ItemStack toRender = ent.getMainHandItem().copy();
                toRender.setCount(itemCount);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Minecraft.getInstance().gui.renderSlot(event.getGuiGraphics(), prime, i2, DeltaTracker.ZERO, (Player)ent, toRender, 0);
                RenderSystem.disableBlend();
            }
        }
    }

    private static /* synthetic */ boolean lambda$renderOverlay$8(Player ent, ItemStack st) {
        return ItemStack.isSameItemSameComponents((ItemStack)st, (ItemStack)ent.getMainHandItem());
    }
}

