/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet;

import guideme.internal.shaded.lucene.facet.DrillDownQuery;
import guideme.internal.shaded.lucene.facet.DrillSidewaysQuery;
import guideme.internal.shaded.lucene.facet.Facets;
import guideme.internal.shaded.lucene.facet.FacetsCollector;
import guideme.internal.shaded.lucene.facet.FacetsCollectorManager;
import guideme.internal.shaded.lucene.facet.FacetsConfig;
import guideme.internal.shaded.lucene.facet.MultiFacets;
import guideme.internal.shaded.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import guideme.internal.shaded.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import guideme.internal.shaded.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import guideme.internal.shaded.lucene.facet.taxonomy.TaxonomyReader;
import guideme.internal.shaded.lucene.search.Collector;
import guideme.internal.shaded.lucene.search.CollectorManager;
import guideme.internal.shaded.lucene.search.FieldDoc;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.MatchAllDocsQuery;
import guideme.internal.shaded.lucene.search.MultiCollectorManager;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.ScoreDoc;
import guideme.internal.shaded.lucene.search.Sort;
import guideme.internal.shaded.lucene.search.TopDocs;
import guideme.internal.shaded.lucene.search.TopFieldCollector;
import guideme.internal.shaded.lucene.search.TopFieldCollectorManager;
import guideme.internal.shaded.lucene.search.TopFieldDocs;
import guideme.internal.shaded.lucene.search.TopScoreDocCollectorManager;
import guideme.internal.shaded.lucene.util.ThreadInterruptedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class DrillSideways {
    protected final IndexSearcher searcher;
    protected final TaxonomyReader taxoReader;
    protected final SortedSetDocValuesReaderState state;
    protected final FacetsConfig config;
    private final ExecutorService executor;

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, TaxonomyReader taxoReader) {
        this(searcher, config, taxoReader, null);
    }

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, SortedSetDocValuesReaderState state) {
        this(searcher, config, null, state);
    }

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, TaxonomyReader taxoReader, SortedSetDocValuesReaderState state) {
        this(searcher, config, taxoReader, state, null);
    }

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, TaxonomyReader taxoReader, SortedSetDocValuesReaderState state, ExecutorService executor) {
        this.searcher = searcher;
        this.config = config;
        this.taxoReader = taxoReader;
        this.state = state;
        this.executor = executor;
    }

    protected FacetsCollectorManager createDrillDownFacetsCollectorManager() {
        return new FacetsCollectorManager();
    }

    protected FacetsCollectorManager createDrillSidewaysFacetsCollectorManager() {
        return new FacetsCollectorManager();
    }

    protected Facets buildFacetsResult(FacetsCollector drillDowns, FacetsCollector[] drillSideways, String[] drillSidewaysDims) throws IOException {
        Facets drillDownFacets = null;
        HashMap<String, Facets> drillSidewaysFacets = new HashMap<String, Facets>();
        if (this.taxoReader != null) {
            if (drillDowns != null) {
                drillDownFacets = new FastTaxonomyFacetCounts(this.taxoReader, this.config, drillDowns);
            }
            if (drillSideways != null) {
                for (int i = 0; i < drillSideways.length; ++i) {
                    drillSidewaysFacets.put(drillSidewaysDims[i], new FastTaxonomyFacetCounts(this.taxoReader, this.config, drillSideways[i]));
                }
            }
        } else {
            if (drillDowns != null) {
                drillDownFacets = new SortedSetDocValuesFacetCounts(this.state, drillDowns);
            }
            if (drillSideways != null) {
                for (int i = 0; i < drillSideways.length; ++i) {
                    drillSidewaysFacets.put(drillSidewaysDims[i], new SortedSetDocValuesFacetCounts(this.state, drillSideways[i]));
                }
            }
        }
        if (drillSidewaysFacets.isEmpty()) {
            return drillDownFacets;
        }
        return new MultiFacets(drillSidewaysFacets, drillDownFacets);
    }

    public DrillSidewaysResult search(DrillDownQuery query, Query filter, FieldDoc after, int topN, Sort sort, boolean doDocScores) throws IOException {
        if (filter != null) {
            query = new DrillDownQuery(this.config, filter, query);
        }
        if (sort != null) {
            int limit = this.searcher.getIndexReader().maxDoc();
            if (limit == 0) {
                limit = 1;
            }
            int fTopN = Math.min(topN, limit);
            TopFieldCollectorManager collectorManager = new TopFieldCollectorManager(sort, fTopN, after, Integer.MAX_VALUE);
            ConcurrentDrillSidewaysResult<TopFieldDocs> r = this.search(query, collectorManager);
            TopFieldDocs topDocs = (TopFieldDocs)r.collectorResult;
            if (doDocScores) {
                TopFieldCollector.populateScores(topDocs.scoreDocs, this.searcher, query);
            }
            return new DrillSidewaysResult(r.facets, (TopDocs)r.collectorResult, r.drillDownFacetsCollector, r.drillSidewaysFacetsCollector, r.drillSidewaysDims);
        }
        return this.search(after, query, topN);
    }

    public DrillSidewaysResult search(DrillDownQuery query, int topN) throws IOException {
        return this.search(null, query, topN);
    }

    public DrillSidewaysResult search(ScoreDoc after, DrillDownQuery query, int topN) throws IOException {
        int limit = this.searcher.getIndexReader().maxDoc();
        if (limit == 0) {
            limit = 1;
        }
        int fTopN = Math.min(topN, limit);
        TopScoreDocCollectorManager collectorManager = new TopScoreDocCollectorManager(fTopN, after, Integer.MAX_VALUE);
        ConcurrentDrillSidewaysResult<TopDocs> r = this.search(query, collectorManager);
        return new DrillSidewaysResult(r.facets, (TopDocs)r.collectorResult, r.drillDownFacetsCollector, r.drillSidewaysFacetsCollector, r.drillSidewaysDims);
    }

    protected boolean scoreSubDocsAtOnce() {
        return false;
    }

    private DrillDownQuery getDrillDownQuery(DrillDownQuery query, Query[] queries, String excludedDimension) {
        DrillDownQuery ddl = new DrillDownQuery(this.config, query.getBaseQuery());
        query.getDims().forEach((dim, pos) -> {
            if (!dim.equals(excludedDimension)) {
                ddl.add((String)dim, queries[pos]);
            }
        });
        return ddl.getDims().size() == queries.length ? null : ddl;
    }

    public <R> ConcurrentDrillSidewaysResult<R> search(DrillDownQuery query, CollectorManager<?, R> hitCollectorManager) throws IOException {
        FacetsCollector[] drillSidewaysCollectors;
        String[] drillSidewaysDims;
        Object hitCollectorResult;
        FacetsCollector facetsCollectorResult;
        ArrayList<FacetsCollectorManager> drillSidewaysCollectorManagers;
        FacetsCollectorManager drillDownFacetsCollectorManager = this.createDrillDownFacetsCollectorManager();
        MultiCollectorManager mainCollectorManager = drillDownFacetsCollectorManager != null ? new MultiCollectorManager(drillDownFacetsCollectorManager, hitCollectorManager) : hitCollectorManager;
        if (!query.getDims().isEmpty()) {
            drillSidewaysCollectorManagers = new ArrayList<FacetsCollectorManager>(query.getDims().size());
            for (int i = 0; i < query.getDims().size(); ++i) {
                drillSidewaysCollectorManagers.add(this.createDrillSidewaysFacetsCollectorManager());
            }
        } else {
            drillSidewaysCollectorManagers = null;
        }
        Result<Object[], R> result = this.executor != null ? this.searchConcurrently(query, mainCollectorManager, drillSidewaysCollectorManagers) : this.searchSequentially(query, mainCollectorManager, drillSidewaysCollectorManagers);
        if (drillDownFacetsCollectorManager != null) {
            Object[] drillDownResult = (Object[])result.drillDownResult;
            facetsCollectorResult = (FacetsCollector)drillDownResult[0];
            hitCollectorResult = drillDownResult[1];
        } else {
            facetsCollectorResult = null;
            hitCollectorResult = result.drillDownResult;
        }
        if (!query.getDims().isEmpty()) {
            drillSidewaysDims = query.getDims().keySet().toArray(new String[0]);
            int numDims = query.getDims().size();
            assert (drillSidewaysCollectorManagers != null);
            assert (drillSidewaysCollectorManagers.size() == numDims);
            drillSidewaysCollectors = new FacetsCollector[numDims];
            for (int dim = 0; dim < numDims; ++dim) {
                drillSidewaysCollectors[dim] = (FacetsCollector)result.drillSidewaysResults.get(dim);
            }
        } else {
            drillSidewaysDims = null;
            drillSidewaysCollectors = null;
        }
        return new ConcurrentDrillSidewaysResult(this.buildFacetsResult(facetsCollectorResult, drillSidewaysCollectors, drillSidewaysDims), null, hitCollectorResult, facetsCollectorResult, drillSidewaysCollectors, drillSidewaysDims);
    }

    public <C extends Collector, T, K extends Collector, R> Result<T, R> search(DrillDownQuery query, CollectorManager<C, T> drillDownCollectorManager, List<? extends CollectorManager<K, R>> drillSidewaysCollectorManagers) throws IOException {
        if (drillDownCollectorManager == null) {
            throw new IllegalArgumentException("This search method requires client to provide drill down collector manager");
        }
        if (drillSidewaysCollectorManagers == null) {
            if (!query.getDims().isEmpty()) {
                throw new IllegalArgumentException("The query requires not null drillSidewaysCollectorManagers");
            }
        } else if (drillSidewaysCollectorManagers.size() != query.getDims().size()) {
            throw new IllegalArgumentException("drillSidewaysCollectorManagers size must be equal to number of dimensions in the query.");
        }
        if (this.executor != null) {
            return this.searchConcurrently(query, drillDownCollectorManager, drillSidewaysCollectorManagers);
        }
        return this.searchSequentially(query, drillDownCollectorManager, drillSidewaysCollectorManagers);
    }

    private <C extends Collector, T, K extends Collector, R> Result<T, R> searchSequentially(DrillDownQuery query, CollectorManager<C, T> drillDownCollectorManager, List<? extends CollectorManager<K, R>> drillSidewaysCollectorManagers) throws IOException {
        Map<String, Integer> drillDownDims = query.getDims();
        if (drillDownDims.isEmpty()) {
            return new Result(this.searcher.search((Query)query, drillDownCollectorManager), null);
        }
        Query baseQuery = query.getBaseQuery();
        if (baseQuery == null) {
            baseQuery = new MatchAllDocsQuery();
        }
        Query[] drillDownQueries = query.getDrillDownQueries();
        DrillSidewaysQuery dsq = new DrillSidewaysQuery(baseQuery, drillSidewaysCollectorManagers, drillDownQueries, this.scoreSubDocsAtOnce());
        T collectorResult = this.searcher.search(dsq, drillDownCollectorManager);
        ArrayList<R> drillSidewaysResults = new ArrayList<R>(drillDownDims.size());
        assert (drillSidewaysCollectorManagers != null) : "Case without drill sideways dimensions is handled above";
        int numSlices = dsq.managedDrillSidewaysCollectors.size();
        for (int dim = 0; dim < drillDownDims.size(); ++dim) {
            ArrayList<Collector> collectorsForDim = new ArrayList<Collector>(numSlices);
            for (int slice = 0; slice < numSlices; ++slice) {
                collectorsForDim.add((Collector)dsq.managedDrillSidewaysCollectors.get(slice).get(dim));
            }
            drillSidewaysResults.add(dim, drillSidewaysCollectorManagers.get(dim).reduce(collectorsForDim));
        }
        return new Result(collectorResult, drillSidewaysResults);
    }

    private <C extends Collector, T, K extends Collector, R> Result<T, R> searchConcurrently(DrillDownQuery query, CollectorManager<C, T> drillDownCollectorManager, List<? extends CollectorManager<K, R>> drillSidewaysCollectorManagers) {
        Map<String, Integer> drillDownDims = query.getDims();
        CallableCollector<T> drillDownCallableCollector = new CallableCollector<T>(this.searcher, query, drillDownCollectorManager);
        ArrayList<CallableCollector<R>> drillSidewaysCallableCollectors = new ArrayList<CallableCollector<R>>(drillDownDims.size());
        int i = 0;
        Query[] filters = query.getDrillDownQueries();
        for (String dim : drillDownDims.keySet()) {
            drillSidewaysCallableCollectors.add(new CallableCollector<R>(this.searcher, this.getDrillDownQuery(query, filters, dim), drillSidewaysCollectorManagers.get(i)));
            ++i;
        }
        try {
            Future<T> drillDownFuture = this.executor.submit(drillDownCallableCollector);
            List drillSidewaysFutures = this.executor.invokeAll(drillSidewaysCallableCollectors);
            T collectorResult = drillDownFuture.get();
            ArrayList drillSidewaysResults = new ArrayList(drillDownDims.size());
            for (i = 0; i < drillSidewaysFutures.size(); ++i) {
                drillSidewaysResults.add(i, drillSidewaysFutures.get(i).get());
            }
            return new Result(collectorResult, drillSidewaysResults);
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ConcurrentDrillSidewaysResult<R>
    extends DrillSidewaysResult {
        public final R collectorResult;

        ConcurrentDrillSidewaysResult(Facets facets, TopDocs hits, R collectorResult, FacetsCollector drillDownFacetsCollector, FacetsCollector[] drillSidewaysFacetsCollector, String[] drillSidewaysDims) {
            super(facets, hits, drillDownFacetsCollector, drillSidewaysFacetsCollector, drillSidewaysDims);
            this.collectorResult = collectorResult;
        }
    }

    public static class DrillSidewaysResult {
        public final Facets facets;
        public final TopDocs hits;
        public final FacetsCollector drillDownFacetsCollector;
        public final FacetsCollector[] drillSidewaysFacetsCollector;
        public final String[] drillSidewaysDims;

        public DrillSidewaysResult(Facets facets, TopDocs hits, FacetsCollector drillDownFacetsCollector, FacetsCollector[] drillSidewaysFacetsCollector, String[] drillSidewaysDims) {
            this.facets = facets;
            this.hits = hits;
            this.drillDownFacetsCollector = drillDownFacetsCollector;
            this.drillSidewaysFacetsCollector = drillSidewaysFacetsCollector;
            this.drillSidewaysDims = drillSidewaysDims;
        }
    }

    public record Result<T, R>(T drillDownResult, List<R> drillSidewaysResults) {
    }

    private record CallableCollector<R>(IndexSearcher searcher, Query query, CollectorManager<?, R> collectorManager) implements Callable<R>
    {
        @Override
        public R call() throws Exception {
            return this.searcher.search(this.query, this.collectorManager);
        }
    }
}

