/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.xml.builders;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.queryparser.classic.ParseException;
import guideme.internal.shaded.lucene.queryparser.classic.QueryParser;
import guideme.internal.shaded.lucene.queryparser.xml.DOMUtils;
import guideme.internal.shaded.lucene.queryparser.xml.ParserException;
import guideme.internal.shaded.lucene.queryparser.xml.QueryBuilder;
import guideme.internal.shaded.lucene.search.BoostQuery;
import guideme.internal.shaded.lucene.search.Query;
import org.w3c.dom.Element;

public class UserInputQueryBuilder
implements QueryBuilder {
    private QueryParser unSafeParser;
    private Analyzer analyzer;
    private String defaultField;

    public UserInputQueryBuilder(QueryParser parser) {
        this.unSafeParser = parser;
    }

    public UserInputQueryBuilder(String defaultField, Analyzer analyzer) {
        this.analyzer = analyzer;
        this.defaultField = defaultField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query getQuery(Element e) throws ParserException {
        String text = DOMUtils.getText(e);
        try {
            Query q = null;
            if (this.unSafeParser != null) {
                QueryParser queryParser = this.unSafeParser;
                synchronized (queryParser) {
                    q = this.unSafeParser.parse(text);
                }
            } else {
                String fieldName = DOMUtils.getAttribute(e, "fieldName", this.defaultField);
                QueryParser parser = this.createQueryParser(fieldName, this.analyzer);
                q = parser.parse(text);
            }
            float boost = DOMUtils.getAttribute(e, "boost", 1.0f);
            return new BoostQuery(q, boost);
        }
        catch (ParseException e1) {
            throw new ParserException(e1.getMessage());
        }
    }

    protected QueryParser createQueryParser(String fieldName, Analyzer analyzer) {
        return new QueryParser(fieldName, analyzer);
    }
}

