/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.BulkScorer;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.LeafCollector;
import guideme.internal.shaded.lucene.search.Scorable;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.ScorerUtil;
import guideme.internal.shaded.lucene.util.Bits;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class ConjunctionBulkScorer
extends BulkScorer {
    private final Scorable[] scoringScorers;
    private final DocIdSetIterator lead1;
    private final DocIdSetIterator lead2;
    private final List<DocIdSetIterator> others;
    private final Scorable scorable;

    ConjunctionBulkScorer(List<Scorer> requiredScoring, List<Scorer> requiredNoScoring) throws IOException {
        int numClauses = requiredScoring.size() + requiredNoScoring.size();
        if (numClauses <= 1) {
            throw new IllegalArgumentException("Expected 2 or more clauses, got " + numClauses);
        }
        final ArrayList<Scorer> allScorers = new ArrayList<Scorer>();
        allScorers.addAll(requiredScoring);
        allScorers.addAll(requiredNoScoring);
        this.scoringScorers = (Scorable[])requiredScoring.stream().map(ScorerUtil::likelyTermScorer).toArray(Scorable[]::new);
        ArrayList<DocIdSetIterator> iterators = new ArrayList<DocIdSetIterator>();
        for (Scorer scorer : allScorers) {
            iterators.add(scorer.iterator());
        }
        Collections.sort(iterators, Comparator.comparingLong(DocIdSetIterator::cost));
        this.lead1 = (DocIdSetIterator)iterators.get(0);
        this.lead2 = (DocIdSetIterator)iterators.get(1);
        this.others = List.copyOf(iterators.subList(2, iterators.size()));
        this.scorable = new Scorable(){

            @Override
            public float score() throws IOException {
                double score = 0.0;
                for (Scorable scorer : ConjunctionBulkScorer.this.scoringScorers) {
                    score += (double)scorer.score();
                }
                return (float)score;
            }

            @Override
            public Collection<Scorable.ChildScorable> getChildren() throws IOException {
                ArrayList<Scorable.ChildScorable> children = new ArrayList<Scorable.ChildScorable>();
                for (Scorer scorer : allScorers) {
                    children.add(new Scorable.ChildScorable(scorer, "MUST"));
                }
                return children;
            }
        };
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        int next;
        int doc;
        assert (this.lead1.docID() >= this.lead2.docID());
        if (this.lead1.docID() < min) {
            this.lead1.advance(min);
        }
        if (this.lead1.docID() >= max) {
            return this.lead1.docID();
        }
        collector.setScorer(this.scorable);
        List<DocIdSetIterator> otherIterators = this.others;
        DocIdSetIterator collectorIterator = collector.competitiveIterator();
        if (collectorIterator != null) {
            otherIterators = new ArrayList<DocIdSetIterator>(otherIterators);
            otherIterators.add(collectorIterator);
        }
        DocIdSetIterator[] others = (DocIdSetIterator[])otherIterators.toArray(DocIdSetIterator[]::new);
        if (this.lead1.docID() == this.lead2.docID()) {
            doc = this.lead1.docID();
            if (acceptDocs == null || acceptDocs.get(doc)) {
                boolean match = true;
                for (DocIdSetIterator it : others) {
                    if (it.docID() < doc && (next = it.advance(doc)) != doc) {
                        this.lead1.advance(next);
                        match = false;
                        break;
                    }
                    assert (it.docID() == doc);
                }
                if (match) {
                    collector.collect(doc);
                    this.lead1.nextDoc();
                }
            } else {
                this.lead1.nextDoc();
            }
        }
        doc = this.lead1.docID();
        block1: while (doc < max) {
            assert (this.lead2.docID() < doc);
            if (acceptDocs != null && !acceptDocs.get(doc)) {
                doc = this.lead1.nextDoc();
                continue;
            }
            int next2 = this.lead2.advance(doc);
            if (next2 != doc) {
                doc = this.lead1.advance(next2);
                if (doc != next2) continue;
                if (doc >= max) break;
                if (acceptDocs != null && !acceptDocs.get(doc)) {
                    doc = this.lead1.nextDoc();
                    continue;
                }
            }
            assert (this.lead2.docID() == doc);
            for (DocIdSetIterator it : others) {
                if (it.docID() < doc && (next = it.advance(doc)) != doc) {
                    doc = this.lead1.advance(next);
                    continue block1;
                }
                assert (it.docID() == doc);
            }
            collector.collect(doc);
            doc = this.lead1.nextDoc();
        }
        return this.lead1.docID();
    }

    @Override
    public long cost() {
        return this.lead1.cost();
    }
}

