/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.document.Document;
import guideme.internal.shaded.lucene.document.FeatureField;
import guideme.internal.shaded.lucene.index.DirectoryReader;
import guideme.internal.shaded.lucene.index.ImpactsEnum;
import guideme.internal.shaded.lucene.index.IndexWriter;
import guideme.internal.shaded.lucene.index.IndexWriterConfig;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.FilterDocIdSetIterator;
import guideme.internal.shaded.lucene.search.FilterScorable;
import guideme.internal.shaded.lucene.search.Scorable;
import guideme.internal.shaded.lucene.search.TermScorer;
import guideme.internal.shaded.lucene.store.ByteBuffersDirectory;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.PriorityQueue;
import java.io.IOException;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;

class ScorerUtil {
    private static final Class<?> DEFAULT_IMPACTS_ENUM_CLASS;

    ScorerUtil() {
    }

    static long costWithMinShouldMatch(LongStream costs, int numScorers, int minShouldMatch) {
        PriorityQueue<Long> pq = new PriorityQueue<Long>(numScorers - minShouldMatch + 1){

            @Override
            protected boolean lessThan(Long a, Long b) {
                return a > b;
            }
        };
        costs.forEach(pq::insertWithOverflow);
        return StreamSupport.stream(pq.spliterator(), false).mapToLong(Number::longValue).sum();
    }

    static DocIdSetIterator likelyImpactsEnum(DocIdSetIterator it) {
        if (it.getClass() != DEFAULT_IMPACTS_ENUM_CLASS && it.getClass() != FilterDocIdSetIterator.class) {
            it = new FilterDocIdSetIterator(it);
        }
        return it;
    }

    static Scorable likelyTermScorer(Scorable scorable) {
        if (scorable.getClass() != TermScorer.class && scorable.getClass() != FilterScorable.class) {
            scorable = new FilterScorable(scorable);
        }
        return scorable;
    }

    static {
        try (ByteBuffersDirectory dir = new ByteBuffersDirectory();
             IndexWriter w = new IndexWriter(dir, new IndexWriterConfig());){
            Document doc = new Document();
            doc.add(new FeatureField("field", "value", 1.0f));
            w.addDocument(doc);
            try (DirectoryReader reader = DirectoryReader.open(w);){
                LeafReader leafReader = reader.leaves().get(0).reader();
                TermsEnum te = leafReader.terms("field").iterator();
                if (!te.seekExact(new BytesRef("value"))) {
                    throw new Error();
                }
                ImpactsEnum ie = te.impacts(8);
                DEFAULT_IMPACTS_ENUM_CLASS = ie.getClass();
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

