/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.counter;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.valhelsia.valhelsia_core.api.common.counter.SimpleCounter;
import org.jetbrains.annotations.NotNull;

public class SerializableCounter
extends SimpleCounter
implements StringRepresentable {
    private final ResourceLocation name;

    public SerializableCounter(ResourceLocation name) {
        this.name = name;
    }

    public SerializableCounter(ResourceLocation name, int value) {
        super(value);
        this.name = name;
    }

    public SerializableCounter(ResourceLocation name, int value, boolean active) {
        super(value, active);
        this.name = name;
    }

    @NotNull
    public String getSerializedName() {
        return this.name.toString();
    }

    public void load(CompoundTag compound) {
        this.value = compound.getInt("value");
        this.active = compound.contains("active") ? compound.getBoolean("active") : true;
    }

    public CompoundTag save(CompoundTag compound) {
        compound.putInt("value", this.value);
        if (!this.isActive()) {
            compound.putBoolean("active", this.active);
        }
        return compound;
    }
}

