/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.datagen.model;

import java.util.Collection;
import java.util.function.Function;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.ModelProvider;
import net.minecraft.world.level.block.Block;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryEntry;
import net.valhelsia.valhelsia_core.datagen.DataProviderContext;
import net.valhelsia.valhelsia_core.datagen.model.BlockModelGenerator;
import net.valhelsia.valhelsia_core.datagen.model.ItemModelGenerator;
import org.jetbrains.annotations.Nullable;

public class ValhelsiaModelProvider
extends ModelProvider {
    @Nullable
    private final Function<BlockModelGenerators, BlockModelGenerator> blockModelGenerator;
    @Nullable
    private final Function<ItemModelGenerators, ItemModelGenerator> itemModelGenerator;
    private final Collection<RegistryEntry<Block, ? extends Block>> blocks;

    public ValhelsiaModelProvider(DataProviderContext context, @Nullable Function<BlockModelGenerators, BlockModelGenerator> blockModelGenerator, @Nullable Function<ItemModelGenerators, ItemModelGenerator> itemModelGenerator) {
        super(context.output());
        this.blockModelGenerator = blockModelGenerator;
        this.itemModelGenerator = itemModelGenerator;
        this.blocks = context.registryManager().getBlockHelper().getRegistryEntries();
    }

    public void generateBlockStateModels(BlockModelGenerators modelGenerators) {
        if (this.blockModelGenerator != null) {
            this.blockModelGenerator.apply(modelGenerators).generate();
        }
    }

    public void generateItemModels(ItemModelGenerators modelGenerators) {
        if (this.itemModelGenerator != null) {
            this.itemModelGenerator.apply(modelGenerators).generate();
        }
    }

    public Collection<RegistryEntry<Block, ? extends Block>> getBlocks() {
        return this.blocks;
    }
}

