/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.unusual.blockfactorysbosses.configuration.ConfigFileConfiguration;
import net.unusual.blockfactorysbosses.entity.NullPrEntity;
import net.unusual.blockfactorysbosses.entity.SlowRotMoveControl;
import net.unusual.blockfactorysbosses.procedures.KnightMoveConditionProcedure;
import net.unusual.blockfactorysbosses.procedures.UnderworldKnightEntityDiesProcedure;
import net.unusual.blockfactorysbosses.procedures.UnderworldKnightEntityIsHurtProcedure;
import net.unusual.blockfactorysbosses.procedures.UnderworldKnightOnEntityTickUpdateProcedure;

public class UnderworldKnightEntity
extends Monster
implements RangedAttackMob {
    public final AnimationState dieAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState spawnAnimationState = new AnimationState();
    public final AnimationState hitAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> DATA_spawn_animtime = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_boss_phase = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_phase = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_cooldown = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_animtime = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_dodge_animtime = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hit_animtime = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_thrust_cooldown = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_thrust_animtime = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_battle_time = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_armor_cooldown = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_armor_animtime = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_undead_cinematic = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_die_animtime = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_source_uuid = SynchedEntityData.defineId(UnderworldKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public UnderworldKnightEntity(EntityType<UnderworldKnightEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setInvisible(true);
        this.moveControl = new SlowRotMoveControl((Mob)this);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_spawn_animtime, (Object)0);
        builder.define(DATA_boss_phase, (Object)0);
        builder.define(DATA_attack_phase, (Object)0);
        builder.define(DATA_attack_cooldown, (Object)0);
        builder.define(DATA_attack_animtime, (Object)0);
        builder.define(DATA_dodge_animtime, (Object)0);
        builder.define(DATA_hit_animtime, (Object)0);
        builder.define(DATA_thrust_cooldown, (Object)0);
        builder.define(DATA_thrust_animtime, (Object)0);
        builder.define(DATA_battle_time, (Object)0);
        builder.define(DATA_armor_cooldown, (Object)3);
        builder.define(DATA_armor_animtime, (Object)0);
        builder.define(DATA_undead_cinematic, (Object)0);
        builder.define(DATA_die_animtime, (Object)0);
        builder.define(DATA_source_uuid, (Object)"");
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 0.8, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return false;
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                UnderworldKnightEntity entity = UnderworldKnightEntity.this;
                return super.canUse() && KnightMoveConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                UnderworldKnightEntity entity = UnderworldKnightEntity.this;
                return super.canContinueToUse() && KnightMoveConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 20, 4.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block_factorys_bosses:knight_footstep")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block_factorys_bosses:knight_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block_factorys_bosses:silence"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        UnderworldKnightEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        if ((Integer)this.entityData.get(DATA_spawn_animtime) > 0 || (Integer)this.entityData.get(DATA_undead_cinematic) > 0) {
            return false;
        }
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        if ((Integer)this.entityData.get(DATA_armor_animtime) == 0 && (Integer)this.entityData.get(DATA_armor_cooldown) > 0) {
            boolean check = UnderworldKnightEntityIsHurtProcedure.execute((LevelAccessor)world, (Entity)entity, sourceentity);
            return super.hurt(damagesource, amount * 0.05f);
        }
        if (UnderworldKnightEntityIsHurtProcedure.execute((LevelAccessor)world, (Entity)entity, sourceentity)) {
            return super.hurt(damagesource, amount);
        }
        return false;
    }

    public void tick() {
        if (this.level().isClientSide) {
            this.dieAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_die_animtime) > 0, this.tickCount);
            this.attackAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_attack_animtime) > 0 && (Integer)this.getEntityData().get(DATA_spawn_animtime) == 0, this.tickCount);
            this.hitAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_hit_animtime) > 0 && (Integer)this.getEntityData().get(DATA_spawn_animtime) == 0, this.tickCount);
            this.idleAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_die_animtime) == 0 && (Integer)this.getEntityData().get(DATA_attack_animtime) == 0 && (Integer)this.getEntityData().get(DATA_hit_animtime) == 0 && ((Integer)this.getEntityData().get(DATA_spawn_animtime) <= 10 || (Integer)this.getEntityData().get(DATA_spawn_animtime) > 226), this.tickCount);
            this.spawnAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_spawn_animtime) > 10 && (Integer)this.getEntityData().get(DATA_spawn_animtime) <= 226, this.tickCount);
        }
        super.tick();
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        UnderworldKnightEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this, source.getEntity());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataspawn_animtime", ((Integer)this.entityData.get(DATA_spawn_animtime)).intValue());
        compound.putInt("Databoss_phase", ((Integer)this.entityData.get(DATA_boss_phase)).intValue());
        compound.putInt("Dataattack_phase", ((Integer)this.entityData.get(DATA_attack_phase)).intValue());
        compound.putInt("Dataattack_cooldown", ((Integer)this.entityData.get(DATA_attack_cooldown)).intValue());
        compound.putInt("Dataattack_animtime", ((Integer)this.entityData.get(DATA_attack_animtime)).intValue());
        compound.putInt("Datadodge_animtime", ((Integer)this.entityData.get(DATA_dodge_animtime)).intValue());
        compound.putInt("Datahit_animtime", ((Integer)this.entityData.get(DATA_hit_animtime)).intValue());
        compound.putInt("Datathrust_cooldown", ((Integer)this.entityData.get(DATA_thrust_cooldown)).intValue());
        compound.putInt("Datathrust_animtime", ((Integer)this.entityData.get(DATA_thrust_animtime)).intValue());
        compound.putInt("Databattle_time", ((Integer)this.entityData.get(DATA_battle_time)).intValue());
        compound.putInt("Dataarmor_cooldown", ((Integer)this.entityData.get(DATA_armor_cooldown)).intValue());
        compound.putInt("Dataarmor_animtime", ((Integer)this.entityData.get(DATA_armor_animtime)).intValue());
        compound.putInt("Dataundead_cinematic", ((Integer)this.entityData.get(DATA_undead_cinematic)).intValue());
        compound.putInt("Datadie_animtime", ((Integer)this.entityData.get(DATA_die_animtime)).intValue());
        compound.putString("Datasource_uuid", (String)this.entityData.get(DATA_source_uuid));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataspawn_animtime")) {
            this.entityData.set(DATA_spawn_animtime, (Object)compound.getInt("Dataspawn_animtime"));
        }
        if (compound.contains("Databoss_phase")) {
            this.entityData.set(DATA_boss_phase, (Object)compound.getInt("Databoss_phase"));
        }
        if (compound.contains("Dataattack_phase")) {
            this.entityData.set(DATA_attack_phase, (Object)compound.getInt("Dataattack_phase"));
        }
        if (compound.contains("Dataattack_cooldown")) {
            this.entityData.set(DATA_attack_cooldown, (Object)compound.getInt("Dataattack_cooldown"));
        }
        if (compound.contains("Dataattack_animtime")) {
            this.entityData.set(DATA_attack_animtime, (Object)compound.getInt("Dataattack_animtime"));
        }
        if (compound.contains("Datadodge_animtime")) {
            this.entityData.set(DATA_dodge_animtime, (Object)compound.getInt("Datadodge_animtime"));
        }
        if (compound.contains("Datahit_animtime")) {
            this.entityData.set(DATA_hit_animtime, (Object)compound.getInt("Datahit_animtime"));
        }
        if (compound.contains("Datathrust_cooldown")) {
            this.entityData.set(DATA_thrust_cooldown, (Object)compound.getInt("Datathrust_cooldown"));
        }
        if (compound.contains("Datathrust_animtime")) {
            this.entityData.set(DATA_thrust_animtime, (Object)compound.getInt("Datathrust_animtime"));
        }
        if (compound.contains("Databattle_time")) {
            this.entityData.set(DATA_battle_time, (Object)compound.getInt("Databattle_time"));
        }
        if (compound.contains("Dataarmor_cooldown")) {
            this.entityData.set(DATA_armor_cooldown, (Object)compound.getInt("Dataarmor_cooldown"));
        }
        if (compound.contains("Dataarmor_animtime")) {
            this.entityData.set(DATA_armor_animtime, (Object)compound.getInt("Dataarmor_animtime"));
        }
        if (compound.contains("Dataundead_cinematic")) {
            this.entityData.set(DATA_armor_animtime, (Object)compound.getInt("Dataundead_cinematic"));
        }
        if (compound.contains("Datadie_animtime")) {
            this.entityData.set(DATA_die_animtime, (Object)compound.getInt("Datadie_animtime"));
        }
        if (compound.contains("Datasource_uuid")) {
            this.entityData.set(DATA_source_uuid, (Object)compound.getString("Datasource_uuid"));
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)ConfigFileConfiguration.KNIGHT_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)ConfigFileConfiguration.KNIGHT_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)ConfigFileConfiguration.KNIGHT_ATK.get()).doubleValue());
        UnderworldKnightEntity underworldKnightEntity = this;
        if (underworldKnightEntity instanceof LivingEntity) {
            UnderworldKnightEntity _entity = underworldKnightEntity;
            _entity.setHealth((float)((Double)ConfigFileConfiguration.KNIGHT_HEALTH.get()).doubleValue());
        }
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        UnderworldKnightOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        NullPrEntity.shoot((LivingEntity)this, target);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 250.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 15.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 64.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.2);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        return builder;
    }
}

