/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.procedures;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModAttributes;

@EventBusSubscriber(value={Dist.CLIENT})
public class OnRenderPlayerPreProcedure {
    @SubscribeEvent
    public static void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        PoseStack matrix = event.getPoseStack();
        float partial = event.getPartialTick();
        if (!OnRenderPlayerPreProcedure.isRolling(player)) {
            return;
        }
        matrix.pushPose();
        float roll = ((float)player.getAttribute(BlockFactorysBossesModAttributes.ROLL_ANIMTIME).getBaseValue() - partial - 90.0f) / 10.0f;
        float yaw = (float)(Math.atan2(player.getDeltaMovement().x(), player.getDeltaMovement().z()) * -57.29577951308232 + 180.0);
        matrix.translate(0.0, (double)((1.0f - roll) * 0.0f) + (double)roll * -1.5, 0.0);
        matrix.mulPose(Axis.YN.rotationDegrees(yaw));
        matrix.translate(0.0, 1.5, 0.0);
        matrix.mulPose(Axis.XP.rotationDegrees(((float)player.getAttribute(BlockFactorysBossesModAttributes.ROLL_ANIMTIME).getBaseValue() - partial) * 36.0f));
        matrix.translate(0.0, -1.5, 0.0);
        matrix.mulPose(Axis.YN.rotationDegrees(-yaw));
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        Player player = event.getEntity();
        PoseStack matrix = event.getPoseStack();
        if (!OnRenderPlayerPreProcedure.isRolling(player)) {
            return;
        }
        matrix.popPose();
    }

    private static boolean isRolling(Player player) {
        return player.getAttribute(BlockFactorysBossesModAttributes.ROLL_ANIMTIME).getBaseValue() > 90.0 && player.getAttribute(BlockFactorysBossesModAttributes.ROLL_ANIMTIME).getBaseValue() <= 100.0;
    }
}

