/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_caelum.ritual;

import com.hollingsworth.ars_caelum.ArsCaelum;
import com.hollingsworth.ars_caelum.lib.RitualLang;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CobbleRitual
extends AbstractRitual {
    int converted;

    protected void tick() {
        int range = 1;
        if (this.getWorld().isClientSide) {
            ParticleUtil.spawnRitualAreaEffect((BlockPos)this.getPos(), (Level)this.getWorld(), (RandomSource)this.getWorld().getRandom(), (ParticleColor)this.getCenterColor(), (int)range);
        } else if (this.getWorld().getGameTime() % 15L == 0L) {
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.getPos().offset(-range, -1, -range), (BlockPos)this.getPos().offset(range, 1, range))) {
                if (!this.getWorld().getBlockState(pos).getFluidState().isSource() || !this.getWorld().getBlockState(pos).is(Blocks.WATER)) continue;
                this.getWorld().setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                this.getWorld().playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                ++this.converted;
                if (this.converted >= 4) {
                    this.converted = 0;
                    boolean isDeepslate = this.getConsumedItems().stream().anyMatch(itemStack -> itemStack.getItem() == Blocks.DEEPSLATE.defaultBlockState().getBlock().asItem());
                    BlockState state = isDeepslate ? Blocks.DEEPSLATE.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState();
                    this.getWorld().setBlockAndUpdate(pos, state);
                }
                return;
            }
        }
    }

    public boolean canConsumeItem(ItemStack stack) {
        boolean isDeepslate = this.getConsumedItems().stream().anyMatch(itemStack -> itemStack.getItem() == Blocks.DEEPSLATE.defaultBlockState().getBlock().asItem());
        return super.canConsumeItem(stack) || !isDeepslate && stack.getItem() == Blocks.DEEPSLATE.defaultBlockState().getBlock().asItem();
    }

    public ParticleColor getCenterColor() {
        return new ParticleColor(100, 200, 255);
    }

    public ParticleColor getOuterColor() {
        return new ParticleColor(100, 200, 255);
    }

    public ResourceLocation getRegistryName() {
        return ArsCaelum.prefix(RitualLang.COBBLE);
    }

    public String getLangName() {
        return "Sedimentation";
    }

    public String getLangDescription() {
        return "Converts four nearby water sources and will produce cobblestone on the last source consumed. Augment with Deepslate to produce Deepslate instead.";
    }
}

