/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import dev.terminalmc.commandkeys.config.Config;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.screen.EditScreen;
import dev.terminalmc.commandkeys.gui.screen.MainOptionScreen;
import dev.terminalmc.commandkeys.mixin.accessor.ChatScreenAccessor;
import dev.terminalmc.commandkeys.util.Localization;
import dev.terminalmc.commandkeys.util.ModLogger;
import dev.terminalmc.commandkeys.util.PlaceholderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class CommandKeys {
    public static final String MOD_ID = "commandkeys";
    public static final String MOD_NAME = "CommandKeys";
    public static final ModLogger LOG = new ModLogger("CommandKeys");
    public static final Component PREFIX = Component.empty().append((Component)Component.literal((String)"[").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)"CommandKeys").withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)"] ").withStyle(ChatFormatting.DARK_GRAY)).withStyle(ChatFormatting.GRAY);
    public static final KeyMapping CONFIG_KEY = new KeyMapping(Localization.translationKey("key", "main.edit"), InputConstants.Type.KEYSYM, 75, Localization.translationKey("key", "main"));
    public static final List<KeyMapping> KEYBINDS = List.of(CONFIG_KEY);
    public static boolean hasResetConfig = false;
    public static String lastConnection = "";
    @Nullable
    public static InputConstants.Key ratelimitedKey = null;
    private static final List<TickCounter> rateLimiter = new ArrayList<TickCounter>();

    public static void init() {
        Config.getAndSave();
    }

    public static void afterClientTick(Minecraft mc) {
        while (CONFIG_KEY.consumeClick()) {
            mc.setScreen((Screen)new MainOptionScreen(mc.screen, true));
        }
        rateLimiter.removeIf(tc -> tc.tick() > Config.get().getRatelimitTicks());
        if (mc.player != null && mc.level != null && !mc.isPaused()) {
            Config.get().activeProfile().getMacros().forEach(Macro::tick);
        }
        if (hasResetConfig && mc.screen instanceof TitleScreen) {
            hasResetConfig = false;
            mc.getToasts().addToast((Toast)new SystemToast(new SystemToast.SystemToastId(15000L), (Component)Localization.localized("toast", "reset.title", new Object[0]), (Component)Localization.localized("toast", "reset.message", Component.literal((String)"commandkeys.unreadable.json").withStyle(ChatFormatting.GOLD))));
        }
    }

    public static void onConfigSaved(Config config) {
    }

    public static Profile profile() {
        return Config.get().activeProfile();
    }

    public static Screen getConfigScreen(Screen lastScreen) {
        return new MainOptionScreen(lastScreen, CommandKeys.inGame());
    }

    public static boolean inGame() {
        LocalPlayer player = Minecraft.getInstance().player;
        return player != null && player.connection.getConnection().isConnected();
    }

    public static boolean inSingleplayer() {
        return Minecraft.getInstance().getSingleplayerServer() != null;
    }

    public static boolean canTrigger(InputConstants.Key key, boolean sendMessage) {
        if ((!CommandKeys.inSingleplayer() || Config.get().ratelimitSp) && rateLimiter.size() >= Config.get().getRatelimitCount()) {
            if (sendMessage && ratelimitedKey != key) {
                Minecraft.getInstance().gui.getChat().addMessage((Component)PREFIX.copy().append((Component)Localization.localized("message", "blocked.ratelimit", key.getDisplayName().copy().withStyle(ChatFormatting.GRAY), Component.literal((String)String.valueOf(Config.get().getRatelimitCount())).withStyle(ChatFormatting.GRAY), Component.literal((String)String.valueOf(Config.get().getRatelimitTicks())).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.RED)));
                ratelimitedKey = key;
            }
            if (Config.getAndSave().ratelimitStrict) {
                rateLimiter.add(new TickCounter());
            }
            return false;
        }
        rateLimiter.add(new TickCounter());
        return true;
    }

    public static void send(String message, boolean addToHistory, boolean showHudMsg) {
        CommandKeys.send(message, false, false, addToHistory, showHudMsg);
    }

    public static void type(String message) {
        CommandKeys.send(message, true, false, false, false);
    }

    public static void edit(String message) {
        CommandKeys.send(message, false, true, false, false);
    }

    public static void send(String message, boolean type, boolean edit, boolean addToHistory, boolean showHudMsg) {
        ratelimitedKey = null;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (!mc.player.connection.isAcceptingMessages()) {
            return;
        }
        Pair<String, Integer> result = PlaceholderUtil.replace(message);
        message = (String)result.getFirst();
        int faults = (Integer)result.getSecond();
        if (faults == 0) {
            if (edit) {
                String finalMessage = message;
                mc.setScreen((Screen)new EditScreen(str -> CommandKeys.send(type, finalMessage.replaceAll("%edit%", (String)str), addToHistory, showHudMsg)));
            } else {
                CommandKeys.send(type, message, addToHistory, showHudMsg);
            }
        } else {
            MutableComponent msg = PREFIX.copy();
            msg.append((Component)Localization.localized("message", "placeholderFault", Component.literal((String)message).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.RED));
            mc.gui.getChat().addMessage((Component)msg);
        }
    }

    private static void send(boolean type, String message, boolean addToHistory, boolean showHudMsg) {
        Minecraft mc = Minecraft.getInstance();
        if (type) {
            EditBox input;
            ChatScreen screen = new ChatScreen(message);
            mc.setScreen((Screen)screen);
            int index = message.indexOf("%edit%");
            if (index != -1 && (input = ((ChatScreenAccessor)screen).commandkeys$getInput()) != null) {
                input.moveCursorTo(index + "%edit%".length(), false);
                input.moveCursorTo(index, true);
            }
        } else if (message.length() > Config.get().getLengthLimitLength()) {
            MutableComponent msg = PREFIX.copy();
            msg.append((Component)Localization.localized("message", "blocked.lengthlimit", Component.literal((String)String.valueOf(message.length())).withStyle(ChatFormatting.GRAY), Component.literal((String)String.valueOf(Config.get().getLengthLimitLength())).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.RED));
            mc.gui.getChat().addMessage((Component)msg);
        } else {
            if (message.startsWith("/")) {
                mc.player.connection.sendCommand(message.substring(1));
            } else {
                mc.player.connection.sendChat(message);
            }
            if (addToHistory) {
                mc.gui.getChat().addRecentChat(message);
            }
            if (showHudMsg) {
                mc.gui.setOverlayMessage((Component)Component.literal((String)message).withStyle(ChatFormatting.GRAY), false);
            }
        }
    }

    private static class TickCounter {
        int time = 0;

        private TickCounter() {
        }

        int tick() {
            return this.time++;
        }
    }
}

