/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.screen;

import com.mojang.blaze3d.platform.InputConstants;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class OptionScreen
extends OptionsSubScreen {
    public static final int HEADER_MARGIN = 32;
    public static final int FOOTER_MARGIN = 32;
    public static final int BASE_ROW_WIDTH = 320;
    public static final int SCROLL_BAR_MARGIN = 20;
    public static final int ELEMENT_SPACING = 4;
    public static final int ELEMENT_SPACING_NARROW = 2;
    public static final int ELEMENT_SPACING_FINE = 1;
    public static final int LIST_ENTRY_HEIGHT = 20;
    public static final int LIST_ENTRY_SPACING = 5;
    public static final int HANGING_WIDGET_MARGIN = 24;
    public static final int BASE_LIST_ENTRY_WIDTH = 232;
    protected OptionList list;

    public OptionScreen(Screen lastScreen, Component title, OptionList list) {
        super(lastScreen, Minecraft.getInstance().options, title);
        this.list = list;
        this.list.setScreen(this);
    }

    protected void init() {
        this.clearWidgets();
        this.clearFocus();
        this.addTitle();
        this.addContents();
        this.addFooter();
        this.setInitialFocus();
    }

    public void resize(@NotNull Minecraft mc, int width, int height) {
        this.width = width;
        this.height = height;
        this.init();
    }

    protected void addTitle() {
        Font font = Minecraft.getInstance().font;
        int w = font.width((FormattedText)this.title);
        Objects.requireNonNull(font);
        int h = 9;
        int x = this.width / 2 - w / 2;
        int y = Math.max(0, 16 - h / 2);
        this.addRenderableWidget((GuiEventListener)new StringWidget(x, y, w, h, this.title, font).alignLeft());
    }

    protected void addContents() {
        this.list.updateSizeAndPosition(this.width, this.height - 32 - 32, 32);
        this.addRenderableWidget((GuiEventListener)this.list);
    }

    protected void addFooter() {
        int w = 232;
        int h = 20;
        int x = this.width / 2 - w / 2;
        int y = Math.min(this.height - h, this.height - 16 - h / 2);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).pos(x, y).size(w, h).build());
    }

    protected void addOptions() {
    }

    public void onClose() {
        Screen screen = this.lastScreen;
        if (screen instanceof OptionScreen) {
            OptionScreen screen2 = (OptionScreen)screen;
            screen2.resize(Minecraft.getInstance(), this.width, this.height);
        }
        super.onClose();
    }

    public Screen getLastScreen() {
        return this.lastScreen;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.list.keyPressed(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.list.keyReleased(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int delta) {
        if (this.list.mouseClicked(InputConstants.Type.MOUSE.getOrCreate(delta))) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, delta);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int delta) {
        if (this.list.mouseReleased(InputConstants.Type.MOUSE.getOrCreate(delta))) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, delta);
    }
}

