/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.screen;

import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.cucumber.client.screen.widget.EnergyBarWidget;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.api.crafting.ICombinationRecipe;
import com.blakebr0.extendedcrafting.container.CraftingCoreContainer;
import com.blakebr0.extendedcrafting.tileentity.CraftingCoreTileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class CraftingCoreScreen
extends BaseContainerScreen<CraftingCoreContainer> {
    private static final ResourceLocation BACKGROUND = ExtendedCrafting.resource("textures/gui/crafting_core.png");
    private CraftingCoreTileEntity tile;

    public CraftingCoreScreen(CraftingCoreContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, BACKGROUND, 176, 194);
    }

    protected void init() {
        super.init();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.tile = this.getTileEntity();
        if (this.tile != null) {
            this.addRenderableWidget((GuiEventListener)new EnergyBarWidget(x + 7, y + 17, (IEnergyStorage)this.tile.getEnergy()));
        }
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        ItemStack output;
        boolean isHoldingItem;
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.render(gfx, mouseX, mouseY, partialTicks);
        if (this.tile != null) {
            this.tile.getActiveRecipe();
        }
        boolean bl = isHoldingItem = !((CraftingCoreContainer)this.menu).getCarried().isEmpty() || this.isDragging();
        if (!isHoldingItem && CraftingCoreScreen.isHoveringSlot(x + 148, y + 47, mouseX, mouseY) && !(output = this.getRecipeOutput()).isEmpty()) {
            gfx.renderTooltip(this.font, output, mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics gfx, int mouseX, int mouseY) {
        String title = this.getTitle().getString();
        gfx.drawString(this.font, title, this.imageWidth / 2 - this.font.width(title) / 2, 6, 0x404040, false);
        gfx.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 94, 0x404040, false);
        PoseStack matrix = gfx.pose();
        matrix.pushPose();
        matrix.scale(0.75f, 0.75f, 0.75f);
        gfx.drawString(this.font, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.pedestals", (Object[])new Object[]{this.getPedestalCount()}), 36, 36, -1);
        if (!this.hasRecipe()) {
            gfx.drawString(this.font, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.no_recipe", (Object[])new Object[0]), 36, 56, -1);
        } else {
            gfx.drawString(this.font, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.power_cost", (Object[])new Object[]{CraftingCoreScreen.number((Object)this.getEnergyRequired())}) + " FE", 36, 56, -1);
            gfx.drawString(this.font, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.power_rate", (Object[])new Object[]{CraftingCoreScreen.number((Object)this.getEnergyRate())}) + " FE/t", 36, 66, -1);
            if (this.getEnergyStored() < this.getEnergyRate()) {
                gfx.drawString(this.font, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.no_power", (Object[])new Object[0]), 36, 86, -1);
            }
        }
        matrix.popPose();
    }

    protected void renderBg(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(gfx, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.hasRecipe()) {
            if (this.getProgress() > 0 && this.getEnergyRate() > 0) {
                int i2 = this.getProgressBarScaled();
                gfx.blit(BACKGROUND, x + 116, y + 47, 194, 0, i2 + 1, 16);
            }
            ItemStack output = this.getRecipeOutput();
            gfx.renderItem(output, x + 148, y + 47);
            if (CraftingCoreScreen.isHoveringSlot(x + 148, y + 47, mouseX, mouseY)) {
                CraftingCoreScreen.renderSlotHighlight((GuiGraphics)gfx, (int)(x + 148), (int)(y + 47), (int)100);
            }
        }
    }

    private CraftingCoreTileEntity getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().level;
        if (level != null && (tile = level.getBlockEntity(((CraftingCoreContainer)this.getMenu()).getBlockPos())) instanceof CraftingCoreTileEntity) {
            CraftingCoreTileEntity core = (CraftingCoreTileEntity)tile;
            return core;
        }
        return null;
    }

    private boolean hasRecipe() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.hasRecipe();
    }

    private ItemStack getRecipeOutput() {
        if (this.tile == null) {
            return ItemStack.EMPTY;
        }
        Level level = this.tile.getLevel();
        if (level == null) {
            return ItemStack.EMPTY;
        }
        ICombinationRecipe recipe = this.tile.getActiveRecipe();
        if (recipe != null) {
            return recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        }
        return ItemStack.EMPTY;
    }

    private int getEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getEnergyStored();
    }

    private int getEnergyRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergyRequired();
    }

    private int getEnergyRate() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergyRate();
    }

    private int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    private int getPedestalCount() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getPedestalCount();
    }

    private int getProgressBarScaled() {
        int i = this.getProgress();
        long j = this.getEnergyRequired();
        return (int)(j != 0L && i != 0 ? (long)i * 24L / j : 0L);
    }

    private static boolean isHoveringSlot(int x, int y, int mouseX, int mouseY) {
        return mouseX > x - 1 && mouseX < x + 16 && mouseY > y - 1 && mouseY < y + 16;
    }
}

