/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.screen;

import com.blakebr0.cucumber.client.render.GhostItemRenderer;
import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.cucumber.client.screen.widget.EnergyBarWidget;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.client.screen.button.RecipeSelectButton;
import com.blakebr0.extendedcrafting.client.screen.button.ToggleTableRunningButton;
import com.blakebr0.extendedcrafting.container.UltimateAutoTableContainer;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class UltimateAutoTableScreen
extends BaseContainerScreen<UltimateAutoTableContainer> {
    public static final ResourceLocation BACKGROUND = ExtendedCrafting.resource("textures/gui/ultimate_auto_table.png");
    private AutoTableTileEntity tile;

    public UltimateAutoTableScreen(UltimateAutoTableContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, BACKGROUND, 254, 278, 512, 512);
    }

    public void init() {
        super.init();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        BlockPos pos = ((UltimateAutoTableContainer)this.getMenu()).getBlockPos();
        this.addRenderableWidget((GuiEventListener)new ToggleTableRunningButton(x + 226, y + 114, pos, this::isRunning));
        this.tile = this.getTileEntity();
        if (this.tile != null) {
            this.addRenderableWidget((GuiEventListener)new RecipeSelectButton(x + 210, y + 7, pos, 0, this.tile.getRecipeStorage(), this::onSelectButtonTooltip));
            this.addRenderableWidget((GuiEventListener)new RecipeSelectButton(x + 223, y + 7, pos, 1, this.tile.getRecipeStorage(), this::onSelectButtonTooltip));
            this.addRenderableWidget((GuiEventListener)new RecipeSelectButton(x + 236, y + 7, pos, 2, this.tile.getRecipeStorage(), this::onSelectButtonTooltip));
            this.addRenderableWidget((GuiEventListener)new EnergyBarWidget(x + 7, y + 59, (IEnergyStorage)this.tile.getEnergy()));
        }
    }

    protected void renderTooltip(GuiGraphics gfx, int mouseX, int mouseY) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.renderTooltip(gfx, mouseX, mouseY);
        if (mouseX > x + 226 && mouseX < x + 239 && mouseY > y + 113 && mouseY < y + 129) {
            gfx.renderTooltip(this.font, (Component)ModTooltips.TOGGLE_AUTO_CRAFTING.color(ChatFormatting.WHITE).build(), mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics gfx, int mouseX, int mouseY) {
        String title = this.getTitle().getString();
        gfx.drawString(this.font, title, 26, 6, 0x404040, false);
        gfx.drawString(this.font, this.playerInventoryTitle, 47, this.imageHeight - 94, 0x404040, false);
    }

    protected void renderBg(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        BaseItemStackHandler recipe;
        super.renderBg(gfx, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.isRunning()) {
            int i2 = this.getProgressBarScaled();
            gfx.blit(BACKGROUND, x + 225, y + 113, 272.0f, 0.0f, 13, i2, 512, 512);
        }
        if ((recipe = this.getSelectedRecipe()) != null) {
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    int index = i * 9 + j;
                    ItemStack item = recipe.getStackInSlot(index);
                    GhostItemRenderer.renderItemIntoGui((ItemStack)item, (int)(x + 27 + j * 18), (int)(y + 18 + i * 18), (ItemRenderer)itemRenderer);
                }
            }
            ItemStack output = recipe.getStackInSlot(recipe.getSlots() - 1);
            GhostItemRenderer.renderItemIntoGui((ItemStack)output, (int)(x + 225), (int)(y + 89), (ItemRenderer)itemRenderer);
        }
    }

    private void onSelectButtonTooltip(Button button, GuiGraphics gfx, int mouseX, int mouseY) {
        int index = ((RecipeSelectButton)button).getIndex();
        boolean isSelected = ((RecipeSelectButton)button).isSelected();
        BaseItemStackHandler recipe = this.getRecipeInfo(index);
        if (recipe != null) {
            ArrayList tooltip;
            boolean hasRecipe;
            boolean bl = hasRecipe = !recipe.getStacks().stream().allMatch(ItemStack::isEmpty);
            if (hasRecipe) {
                ItemStack output = recipe.getStackInSlot(recipe.getSlots() - 1);
                tooltip = Lists.newArrayList((Object[])new Component[]{Component.literal((String)(output.getCount() + "x " + output.getHoverName().getString())), Component.literal((String)""), ModTooltips.AUTO_TABLE_DELETE_RECIPE.color(ChatFormatting.WHITE).build()});
                if (isSelected) {
                    tooltip.add(1, ModTooltips.SELECTED.color(ChatFormatting.GREEN).build());
                }
            } else {
                tooltip = Lists.newArrayList((Object[])new Component[]{ModTooltips.AUTO_TABLE_SAVE_RECIPE.color(ChatFormatting.WHITE).build()});
                if (isSelected) {
                    tooltip.add(0, ModTooltips.SELECTED.color(ChatFormatting.GREEN).build());
                    tooltip.add(1, Component.literal((String)""));
                }
            }
            gfx.renderComponentTooltip(this.font, (List)tooltip, mouseX, mouseY);
        }
    }

    private AutoTableTileEntity getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().level;
        if (level != null && (tile = level.getBlockEntity(((UltimateAutoTableContainer)this.getMenu()).getBlockPos())) instanceof AutoTableTileEntity) {
            AutoTableTileEntity table = (AutoTableTileEntity)tile;
            return table;
        }
        return null;
    }

    private boolean isRunning() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.isRunning();
    }

    private BaseItemStackHandler getRecipeInfo(int selected) {
        if (this.tile == null) {
            return null;
        }
        return this.tile.getRecipeStorage().getRecipe(selected);
    }

    private BaseItemStackHandler getSelectedRecipe() {
        if (this.tile == null) {
            return null;
        }
        return this.tile.getRecipeStorage().getSelectedRecipe();
    }

    private int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    private int getProgressRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgressRequired();
    }

    private int getProgressBarScaled() {
        int i = this.getProgress();
        int j = this.getProgressRequired();
        return j != 0 && i != 0 ? i * 16 / j : 0;
    }
}

