/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.cucumber.crafting.ShapedRecipePatternCodecs;
import com.blakebr0.cucumber.util.TriFunction;
import com.blakebr0.extendedcrafting.api.TableCraftingInput;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;

public class ShapedTableRecipe
implements ITableRecipe {
    private final ShapedRecipePattern pattern;
    private final ItemStack result;
    private final int tier;
    private TriFunction<Integer, Integer, ItemStack, ItemStack> transformer;

    public ShapedTableRecipe(ShapedRecipePattern pattern, ItemStack result, int tier) {
        this.pattern = pattern;
        this.result = result;
        this.tier = tier;
    }

    public boolean matches(TableCraftingInput inventory, Level level) {
        if (this.tier != 0 && this.tier != inventory.tier()) {
            return false;
        }
        return this.pattern.matches((CraftingInput)inventory);
    }

    public ItemStack assemble(TableCraftingInput inventory, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= this.pattern.width() && height >= this.pattern.height();
    }

    public ItemStack getResultItem(HolderLookup.Provider lookup) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.pattern.ingredients();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.SHAPED_TABLE.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.TABLE.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public NonNullList<ItemStack> getRemainingItems(TableCraftingInput inventory) {
        NonNullList remaining;
        block6: {
            int height;
            int width;
            block7: {
                remaining = NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
                for (int i = 0; i < remaining.size(); ++i) {
                    ItemStack item = inventory.getItem(i);
                    if (!item.hasCraftingRemainingItem()) continue;
                    remaining.set(i, (Object)item.getCraftingRemainingItem());
                }
                if (this.transformer == null) break block6;
                width = this.pattern.width();
                height = this.pattern.height();
                if (inventory.width() != width && inventory.height() != height) {
                    return remaining;
                }
                if (!this.matches(inventory, true)) break block7;
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        int index = width - j - 1 + i * width;
                        ItemStack stack = inventory.getItem(j, i);
                        remaining.set(index, (Object)((ItemStack)this.transformer.apply((Object)j, (Object)i, (Object)stack)));
                    }
                }
                break block6;
            }
            if (!this.matches(inventory, false)) break block6;
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int index = j + i * width;
                    ItemStack stack = inventory.getItem(j, i);
                    remaining.set(index, (Object)((ItemStack)this.transformer.apply((Object)j, (Object)i, (Object)stack)));
                }
            }
        }
        return remaining;
    }

    @Override
    public int getTier() {
        if (this.tier > 0) {
            return this.tier;
        }
        int width = this.pattern.width();
        int height = this.pattern.height();
        return width < 4 && height < 4 ? 1 : (width < 6 && height < 6 ? 2 : (width < 8 && height < 8 ? 3 : 4));
    }

    @Override
    public boolean hasRequiredTier() {
        return this.tier > 0;
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    private boolean matches(TableCraftingInput inventory, boolean symmetrical) {
        int width = this.pattern.width();
        int height = this.pattern.height();
        NonNullList ingredients = this.pattern.ingredients();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                ItemStack stack;
                Ingredient ingredient = symmetrical ? (Ingredient)ingredients.get(width - j - 1 + i * width) : (Ingredient)ingredients.get(j + i * width);
                if (ingredient.test(stack = inventory.getItem(j, i))) continue;
                return false;
            }
        }
        return true;
    }

    public void setTransformer(TriFunction<Integer, Integer, ItemStack, ItemStack> transformer) {
        this.transformer = transformer;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedTableRecipe> {
        public static final MapCodec<ShapedTableRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ShapedRecipePatternCodecs.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.optionalFieldOf("tier", (Object)0).forGetter(recipe -> recipe.tier)).apply((Applicative)builder, ShapedTableRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedTableRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ShapedTableRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapedTableRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedTableRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int tier = buffer.readVarInt();
            return new ShapedTableRecipe(pattern, result, tier);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ShapedTableRecipe recipe) {
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeVarInt(recipe.tier);
        }
    }
}

