/*
 * Decompiled with CFR 0.152.
 */
package velvet.mysticalextendedtier.init;

import com.blakebr0.cucumber.block.BaseBlock;
import com.blakebr0.cucumber.item.BaseBlockItem;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import velvet.mysticalextendedtier.block.InfusedFarmlandBlock;
import velvet.mysticalextendedtier.item.EssenceCoalBlockItem;
import velvet.mysticalextendedtier.lib.ModCropTiers;

public final class ModBlocks {
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"mysticalextendedtier");
    public static final Map<String, Supplier<BlockItem>> BLOCK_ITEMS = new LinkedHashMap<String, Supplier<BlockItem>>();
    public static final DeferredHolder<Block, Block> ORNIUM_FARMLAND = ModBlocks.register("ornium_farmland", () -> new InfusedFarmlandBlock(ModCropTiers.SEVEN));
    public static final DeferredHolder<Block, Block> LIGHTIUM_FARMLAND = ModBlocks.register("lightium_farmland", () -> new InfusedFarmlandBlock(ModCropTiers.EIGHT));
    public static final DeferredHolder<Block, Block> TORNIUM_FARMLAND = ModBlocks.register("tornium_farmland", () -> new InfusedFarmlandBlock(ModCropTiers.NINE));
    public static final DeferredHolder<Block, Block> OURANIUM_FARMLAND = ModBlocks.register("ouranium_farmland", () -> new InfusedFarmlandBlock(ModCropTiers.TEN));
    public static final DeferredHolder<Block, Block> ORNIUM_BLOCK = ModBlocks.register("ornium_block", () -> new BaseBlock(SoundType.STONE, 4.0f, 6.0f));
    public static final DeferredHolder<Block, Block> ORNIUM_INGOT_BLOCK = ModBlocks.register("ornium_ingot_block", () -> new BaseBlock(SoundType.METAL, 10.0f, 12.0f));
    public static final DeferredHolder<Block, Block> ORNIUM_GEMSTONE_BLOCK = ModBlocks.register("ornium_gemstone_block", () -> new BaseBlock(SoundType.METAL, 10.0f, 12.0f));
    public static final DeferredHolder<Block, Block> LIGHTIUM_BLOCK = ModBlocks.register("lightium_block", () -> new BaseBlock(SoundType.STONE, 8.0f, 10.0f));
    public static final DeferredHolder<Block, Block> LIGHTIUM_INGOT_BLOCK = ModBlocks.register("lightium_ingot_block", () -> new BaseBlock(SoundType.METAL, 12.0f, 14.0f));
    public static final DeferredHolder<Block, Block> LIGHTIUM_GEMSTONE_BLOCK = ModBlocks.register("lightium_gemstone_block", () -> new BaseBlock(SoundType.METAL, 12.0f, 14.0f));
    public static final DeferredHolder<Block, Block> TORNIUM_BLOCK = ModBlocks.register("tornium_block", () -> new BaseBlock(SoundType.STONE, 10.0f, 12.0f));
    public static final DeferredHolder<Block, Block> TORNIUM_INGOT_BLOCK = ModBlocks.register("tornium_ingot_block", () -> new BaseBlock(SoundType.METAL, 14.0f, 16.0f));
    public static final DeferredHolder<Block, Block> TORNIUM_GEMSTONE_BLOCK = ModBlocks.register("tornium_gemstone_block", () -> new BaseBlock(SoundType.METAL, 14.0f, 16.0f));
    public static final DeferredHolder<Block, Block> OURANIUM_BLOCK = ModBlocks.register("ouranium_block", () -> new BaseBlock(SoundType.STONE, 12.0f, 14.0f));
    public static final DeferredHolder<Block, Block> OURANIUM_INGOT_BLOCK = ModBlocks.register("ouranium_ingot_block", () -> new BaseBlock(SoundType.METAL, 18.0f, 18.0f));
    public static final DeferredHolder<Block, Block> OURANIUM_GEMSTONE_BLOCK = ModBlocks.register("ouranium_gemstone_block", () -> new BaseBlock(SoundType.METAL, 18.0f, 20.0f));
    public static final DeferredHolder<Block, Block> ORNIUM_COAL_BLOCK = ModBlocks.register("ornium_coal_block", () -> new BaseBlock(SoundType.STONE, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 1382400));
    public static final DeferredHolder<Block, Block> LIGHTIUM_COAL_BLOCK = ModBlocks.register("lightium_coal_block", () -> new BaseBlock(SoundType.STONE, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 2764800));
    public static final DeferredHolder<Block, Block> TORNIUM_COAL_BLOCK = ModBlocks.register("tornium_coal_block", () -> new BaseBlock(SoundType.STONE, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 5529600));
    public static final DeferredHolder<Block, Block> OURANIUM_COAL_BLOCK = ModBlocks.register("ouranium_coal_block", () -> new BaseBlock(SoundType.STONE, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 11059200));
    public static final DeferredHolder<Block, Block> INFINTY_CRUX = ModBlocks.register("infinity_crux", () -> new BaseBlock(SoundType.METAL, 20.0f, 20.0f));

    private static DeferredHolder<Block, Block> register(String name, Supplier<Block> block) {
        return ModBlocks.register(name, block, b -> () -> new BaseBlockItem((Block)b.get()));
    }

    private static DeferredHolder<Block, Block> register(String name, Supplier<Block> block, Function<DeferredHolder<Block, Block>, Supplier<? extends BlockItem>> item) {
        DeferredHolder reg = REGISTRY.register(name, block);
        BLOCK_ITEMS.put(name, () -> (BlockItem)((Supplier)item.apply(reg)).get());
        return reg;
    }

    private static DeferredHolder<Block, Block> registerNoItem(String name, Supplier<Block> block) {
        return REGISTRY.register(name, block);
    }
}

