/*
 * Decompiled with CFR 0.152.
 */
package velvet.mysticalextendedtier.init;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.mysticalagriculture.item.EssenceWateringCanItem;
import com.blakebr0.mysticalagriculture.item.armor.EssenceBootsItem;
import com.blakebr0.mysticalagriculture.item.armor.EssenceChestplateItem;
import com.blakebr0.mysticalagriculture.item.armor.EssenceHelmetItem;
import com.blakebr0.mysticalagriculture.item.armor.EssenceLeggingsItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceAxeItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceHoeItem;
import com.blakebr0.mysticalagriculture.item.tool.EssencePickaxeItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceShearsItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceShovelItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceSwordItem;
import com.blakebr0.mysticalagriculture.registry.AugmentRegistry;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import velvet.mysticalextendedtier.MysticalExtendedTier;
import velvet.mysticalextendedtier.init.ModArmorMaterials;
import velvet.mysticalextendedtier.init.ModBlocks;
import velvet.mysticalextendedtier.item.EssenceAppleItem;
import velvet.mysticalextendedtier.item.EssenceCoalItem;
import velvet.mysticalextendedtier.item.EssenceItem;
import velvet.mysticalextendedtier.item.EssencePaxelItem;
import velvet.mysticalextendedtier.lib.ModCropTiers;
import velvet.mysticalextendedtier.lib.ModItemTier;
import velvet.mysticalextendedtier.util.EssenceAppleTier;

public final class ModItems {
    private static final Item.Properties BUCKET_PROPERTIES = new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1);
    public static final DeferredRegister<Item> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"mysticalextendedtier");
    public static final List<Supplier<BlockItem>> BLOCK_ENTRIES = new ArrayList<Supplier<BlockItem>>();
    public static final Map<DeferredHolder<Item, Item>, Supplier<Item>> ENTRIES = new LinkedHashMap<DeferredHolder<Item, Item>, Supplier<Item>>();
    public static final Map<DeferredHolder<Item, Item>, Supplier<Item>> GEAR_ENTRIES = new LinkedHashMap<DeferredHolder<Item, Item>, Supplier<Item>>();
    public static final DeferredHolder<Item, Item> ORNIUM_ESSENCE;
    public static final DeferredHolder<Item, Item> LIGHTIUM_ESSENCE;
    public static final DeferredHolder<Item, Item> TORNIUM_ESSENCE;
    public static final DeferredHolder<Item, Item> OURANIUM_ESSENCE;
    public static final DeferredHolder<Item, Item> ORNIUM_INGOT;
    public static final DeferredHolder<Item, Item> ORNIUM_NUGGET;
    public static final DeferredHolder<Item, Item> ORNIUM_GEMSTONE;
    public static final DeferredHolder<Item, Item> LIGHTIUM_INGOT;
    public static final DeferredHolder<Item, Item> LIGHTIUM_NUGGET;
    public static final DeferredHolder<Item, Item> LIGHTIUM_GEMSTONE;
    public static final DeferredHolder<Item, Item> TORNIUM_INGOT;
    public static final DeferredHolder<Item, Item> TORNIUM_NUGGET;
    public static final DeferredHolder<Item, Item> TORNIUM_GEMSTONE;
    public static final DeferredHolder<Item, Item> OURANIUM_INGOT;
    public static final DeferredHolder<Item, Item> OURANIUM_NUGGET;
    public static final DeferredHolder<Item, Item> OURANIUM_GEMSTONE;
    public static final DeferredHolder<Item, Item> ORNIUM_COAL;
    public static final DeferredHolder<Item, Item> LIGHTIUM_COAL;
    public static final DeferredHolder<Item, Item> TORNIUM_COAL;
    public static final DeferredHolder<Item, Item> OURANIUM_COAL;
    public static final DeferredHolder<Item, Item> ORNIUM_APPLE;
    public static final DeferredHolder<Item, Item> LIGHTIUM_APPLE;
    public static final DeferredHolder<Item, Item> TORNIUM_APPLE;
    public static final DeferredHolder<Item, Item> OURANIUM_APPLE;
    public static final DeferredHolder<Item, Item> ORNIUM_SWORD;
    public static final DeferredHolder<Item, Item> ORNIUM_PICKAXE;
    public static final DeferredHolder<Item, Item> ORNIUM_SHOVEL;
    public static final DeferredHolder<Item, Item> ORNIUM_AXE;
    public static final DeferredHolder<Item, Item> ORNIUM_HOE;
    public static final DeferredHolder<Item, Item> ORNIUM_WATERING_CAN;
    public static final DeferredHolder<Item, Item> ORNIUM_SHEARS;
    public static final DeferredHolder<Item, Item> LIGHTIUM_SWORD;
    public static final DeferredHolder<Item, Item> LIGHTIUM_PICKAXE;
    public static final DeferredHolder<Item, Item> LIGHTIUM_SHOVEL;
    public static final DeferredHolder<Item, Item> LIGHTIUM_AXE;
    public static final DeferredHolder<Item, Item> LIGHTIUM_HOE;
    public static final DeferredHolder<Item, Item> LIGHTIUM_WATERING_CAN;
    public static final DeferredHolder<Item, Item> LIGHTIUM_SHEARS;
    public static final DeferredHolder<Item, Item> TORNIUM_SWORD;
    public static final DeferredHolder<Item, Item> TORNIUM_PICKAXE;
    public static final DeferredHolder<Item, Item> TORNIUM_SHOVEL;
    public static final DeferredHolder<Item, Item> TORNIUM_AXE;
    public static final DeferredHolder<Item, Item> TORNIUM_HOE;
    public static final DeferredHolder<Item, Item> TORNIUM_WATERING_CAN;
    public static final DeferredHolder<Item, Item> TORNIUM_SHEARS;
    public static final DeferredHolder<Item, Item> OURANIUM_SWORD;
    public static final DeferredHolder<Item, Item> OURANIUM_PICKAXE;
    public static final DeferredHolder<Item, Item> OURANIUM_SHOVEL;
    public static final DeferredHolder<Item, Item> OURANIUM_AXE;
    public static final DeferredHolder<Item, Item> OURANIUM_HOE;
    public static final DeferredHolder<Item, Item> OURANIUM_WATERING_CAN;
    public static final DeferredHolder<Item, Item> OURANIUM_SHEARS;
    public static final DeferredHolder<Item, Item> ORNIUM_PAXEL;
    public static final DeferredHolder<Item, Item> LIGHTIUM_PAXEL;
    public static final DeferredHolder<Item, Item> TORNIUM_PAXEL;
    public static final DeferredHolder<Item, Item> OURANIUM_PAXEL;
    public static final DeferredHolder<Item, Item> ORNIUM_HELMET;
    public static final DeferredHolder<Item, Item> ORNIUM_CHESTPLATE;
    public static final DeferredHolder<Item, Item> ORNIUM_LEGGINGS;
    public static final DeferredHolder<Item, Item> ORNIUM_BOOTS;
    public static final DeferredHolder<Item, Item> LIGHTIUM_HELMET;
    public static final DeferredHolder<Item, Item> LIGHTIUM_CHESTPLATE;
    public static final DeferredHolder<Item, Item> LIGHTIUM_LEGGINGS;
    public static final DeferredHolder<Item, Item> LIGHTIUM_BOOTS;
    public static final DeferredHolder<Item, Item> TORNIUM_HELMET;
    public static final DeferredHolder<Item, Item> TORNIUM_CHESTPLATE;
    public static final DeferredHolder<Item, Item> TORNIUM_LEGGINGS;
    public static final DeferredHolder<Item, Item> TORNIUM_BOOTS;
    public static final DeferredHolder<Item, Item> OURANIUM_HELMET;
    public static final DeferredHolder<Item, Item> OURANIUM_CHESTPLATE;
    public static final DeferredHolder<Item, Item> OURANIUM_LEGGINGS;
    public static final DeferredHolder<Item, Item> OURANIUM_BOOTS;

    @SubscribeEvent
    public void onRegisterItems(RegisterEvent event) {
        event.register(Registries.ITEM, (T registry) -> {
            BLOCK_ENTRIES.stream().map(Supplier::get).forEach(item -> {
                ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)item.getBlock());
                registry.register(id, item);
            });
            ENTRIES.forEach((reg, item) -> registry.register(reg.getId(), (Object)((Item)item.get())));
            CropRegistry.getInstance().onRegisterItems(registry);
            GEAR_ENTRIES.forEach((reg, item) -> registry.register(reg.getId(), (Object)((Item)item.get())));
            AugmentRegistry.getInstance().onRegisterItems(registry);
        });
    }

    private static DeferredHolder<Item, Item> register(String name) {
        return ModItems.register(name, BaseItem::new);
    }

    private static DeferredHolder<Item, Item> register(String name, Supplier<Item> item) {
        ResourceLocation id = MysticalExtendedTier.resource(name);
        DeferredHolder holder = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)id);
        ENTRIES.put((DeferredHolder<Item, Item>)holder, item);
        return holder;
    }

    static {
        ModBlocks.BLOCK_ITEMS.forEach((arg_0, arg_1) -> REGISTRY.register(arg_0, arg_1));
        ORNIUM_ESSENCE = REGISTRY.register("ornium_essence", () -> new EssenceItem(ModCropTiers.SEVEN));
        LIGHTIUM_ESSENCE = REGISTRY.register("lightium_essence", () -> new EssenceItem(ModCropTiers.EIGHT));
        TORNIUM_ESSENCE = REGISTRY.register("tornium_essence", () -> new EssenceItem(ModCropTiers.NINE));
        OURANIUM_ESSENCE = REGISTRY.register("ouranium_essence", () -> new EssenceItem(ModCropTiers.TEN));
        ORNIUM_INGOT = REGISTRY.register("ornium_ingot", () -> new BaseItem());
        ORNIUM_NUGGET = REGISTRY.register("ornium_nugget", () -> new BaseItem());
        ORNIUM_GEMSTONE = REGISTRY.register("ornium_gemstone", () -> new BaseItem());
        LIGHTIUM_INGOT = REGISTRY.register("lightium_ingot", () -> new BaseItem());
        LIGHTIUM_NUGGET = REGISTRY.register("lightium_nugget", () -> new BaseItem());
        LIGHTIUM_GEMSTONE = REGISTRY.register("lightium_gemstone", () -> new BaseItem());
        TORNIUM_INGOT = REGISTRY.register("tornium_ingot", () -> new BaseItem());
        TORNIUM_NUGGET = REGISTRY.register("tornium_nugget", () -> new BaseItem());
        TORNIUM_GEMSTONE = REGISTRY.register("tornium_gemstone", () -> new BaseItem());
        OURANIUM_INGOT = REGISTRY.register("ouranium_ingot", () -> new BaseItem());
        OURANIUM_NUGGET = REGISTRY.register("ouranium_nugget", () -> new BaseItem());
        OURANIUM_GEMSTONE = REGISTRY.register("ouranium_gemstone", () -> new BaseItem());
        ORNIUM_COAL = REGISTRY.register("ornium_coal", () -> new EssenceCoalItem(153600));
        LIGHTIUM_COAL = REGISTRY.register("lightium_coal", () -> new EssenceCoalItem(307200));
        TORNIUM_COAL = REGISTRY.register("tornium_coal", () -> new EssenceCoalItem(614400));
        OURANIUM_COAL = REGISTRY.register("ouranium_coal", () -> new EssenceCoalItem(1228800));
        ORNIUM_APPLE = REGISTRY.register("ornium_apple", () -> new EssenceAppleItem(EssenceAppleTier.ORNIUM));
        LIGHTIUM_APPLE = REGISTRY.register("lightium_apple", () -> new EssenceAppleItem(EssenceAppleTier.LIGHTIUM));
        TORNIUM_APPLE = REGISTRY.register("tornium_apple", () -> new EssenceAppleItem(EssenceAppleTier.TORNIUM));
        OURANIUM_APPLE = REGISTRY.register("ouranium_apple", () -> new EssenceAppleItem(EssenceAppleTier.OURANIUM));
        ORNIUM_SWORD = REGISTRY.register("ornium_sword", () -> new EssenceSwordItem((Tier)ModItemTier.ORNIUM, 7, 2));
        ORNIUM_PICKAXE = REGISTRY.register("ornium_pickaxe", () -> new EssencePickaxeItem((Tier)ModItemTier.ORNIUM, 7, 2));
        ORNIUM_SHOVEL = REGISTRY.register("ornium_shovel", () -> new EssenceShovelItem((Tier)ModItemTier.ORNIUM, 7, 2));
        ORNIUM_AXE = REGISTRY.register("ornium_axe", () -> new EssenceAxeItem((Tier)ModItemTier.ORNIUM, 7, 2));
        ORNIUM_HOE = REGISTRY.register("ornium_hoe", () -> new EssenceHoeItem((Tier)ModItemTier.ORNIUM, 7, 2));
        ORNIUM_WATERING_CAN = REGISTRY.register("ornium_watering_can", () -> new EssenceWateringCanItem(15, 0.55, ModCropTiers.SEVEN.getTextColor()));
        ORNIUM_SHEARS = REGISTRY.register("ornium_shears", () -> new EssenceShearsItem((Tier)ModItemTier.ORNIUM, 7, 2));
        LIGHTIUM_SWORD = REGISTRY.register("lightium_sword", () -> new EssenceSwordItem((Tier)ModItemTier.LIGHTIUM, 8, 2));
        LIGHTIUM_PICKAXE = REGISTRY.register("lightium_pickaxe", () -> new EssencePickaxeItem((Tier)ModItemTier.LIGHTIUM, 8, 2));
        LIGHTIUM_SHOVEL = REGISTRY.register("lightium_shovel", () -> new EssenceShovelItem((Tier)ModItemTier.LIGHTIUM, 8, 2));
        LIGHTIUM_AXE = REGISTRY.register("lightium_axe", () -> new EssenceAxeItem((Tier)ModItemTier.LIGHTIUM, 8, 2));
        LIGHTIUM_HOE = REGISTRY.register("lightium_hoe", () -> new EssenceHoeItem((Tier)ModItemTier.LIGHTIUM, 8, 2));
        LIGHTIUM_WATERING_CAN = REGISTRY.register("lightium_watering_can", () -> new EssenceWateringCanItem(17, 0.6, ModCropTiers.EIGHT.getTextColor()));
        LIGHTIUM_SHEARS = REGISTRY.register("lightium_shears", () -> new EssenceShearsItem((Tier)ModItemTier.LIGHTIUM, 8, 2));
        TORNIUM_SWORD = REGISTRY.register("tornium_sword", () -> new EssenceSwordItem((Tier)ModItemTier.TORNIUM, 9, 2));
        TORNIUM_PICKAXE = REGISTRY.register("tornium_pickaxe", () -> new EssencePickaxeItem((Tier)ModItemTier.TORNIUM, 9, 2));
        TORNIUM_SHOVEL = REGISTRY.register("tornium_shovel", () -> new EssenceShovelItem((Tier)ModItemTier.TORNIUM, 9, 2));
        TORNIUM_AXE = REGISTRY.register("tornium_axe", () -> new EssenceAxeItem((Tier)ModItemTier.TORNIUM, 9, 2));
        TORNIUM_HOE = REGISTRY.register("tornium_hoe", () -> new EssenceHoeItem((Tier)ModItemTier.TORNIUM, 9, 2));
        TORNIUM_WATERING_CAN = REGISTRY.register("tornium_watering_can", () -> new EssenceWateringCanItem(19, 0.65, ModCropTiers.EIGHT.getTextColor()));
        TORNIUM_SHEARS = REGISTRY.register("tornium_shears", () -> new EssenceShearsItem((Tier)ModItemTier.TORNIUM, 9, 2));
        OURANIUM_SWORD = REGISTRY.register("ouranium_sword", () -> new EssenceSwordItem((Tier)ModItemTier.OURANIUM, 10, 2));
        OURANIUM_PICKAXE = REGISTRY.register("ouranium_pickaxe", () -> new EssencePickaxeItem((Tier)ModItemTier.OURANIUM, 10, 2));
        OURANIUM_SHOVEL = REGISTRY.register("ouranium_shovel", () -> new EssenceShovelItem((Tier)ModItemTier.OURANIUM, 10, 2));
        OURANIUM_AXE = REGISTRY.register("ouranium_axe", () -> new EssenceAxeItem((Tier)ModItemTier.OURANIUM, 10, 2));
        OURANIUM_HOE = REGISTRY.register("ouranium_hoe", () -> new EssenceHoeItem((Tier)ModItemTier.OURANIUM, 10, 2));
        OURANIUM_WATERING_CAN = REGISTRY.register("ouranium_watering_can", () -> new EssenceWateringCanItem(21, 0.7, ModCropTiers.TEN.getTextColor()));
        OURANIUM_SHEARS = REGISTRY.register("ouranium_shears", () -> new EssenceShearsItem((Tier)ModItemTier.OURANIUM, 10, 2));
        ORNIUM_PAXEL = REGISTRY.register("ornium_paxel", () -> new EssencePaxelItem(ModItemTier.ORNIUM, 7, 2));
        LIGHTIUM_PAXEL = REGISTRY.register("lightium_paxel", () -> new EssencePaxelItem(ModItemTier.LIGHTIUM, 8, 2));
        TORNIUM_PAXEL = REGISTRY.register("tornium_paxel", () -> new EssencePaxelItem(ModItemTier.TORNIUM, 9, 2));
        OURANIUM_PAXEL = REGISTRY.register("ouranium_paxel", () -> new EssencePaxelItem(ModItemTier.OURANIUM, 10, 2));
        ORNIUM_HELMET = REGISTRY.register("ornium_helmet", () -> new EssenceHelmetItem(ModArmorMaterials.ORNIUM, 420, 7, 2));
        ORNIUM_CHESTPLATE = REGISTRY.register("ornium_chestplate", () -> new EssenceChestplateItem(ModArmorMaterials.ORNIUM, 420, 7, 2));
        ORNIUM_LEGGINGS = REGISTRY.register("ornium_leggings", () -> new EssenceLeggingsItem(ModArmorMaterials.ORNIUM, 420, 7, 2));
        ORNIUM_BOOTS = REGISTRY.register("ornium_boots", () -> new EssenceBootsItem(ModArmorMaterials.ORNIUM, 420, 7, 2));
        LIGHTIUM_HELMET = REGISTRY.register("lightium_helmet", () -> new EssenceHelmetItem(ModArmorMaterials.LIGHTIUM, 520, 8, 2));
        LIGHTIUM_CHESTPLATE = REGISTRY.register("lightium_chestplate", () -> new EssenceChestplateItem(ModArmorMaterials.LIGHTIUM, 520, 8, 2));
        LIGHTIUM_LEGGINGS = REGISTRY.register("lightium_leggings", () -> new EssenceLeggingsItem(ModArmorMaterials.LIGHTIUM, 520, 8, 2));
        LIGHTIUM_BOOTS = REGISTRY.register("lightium_boots", () -> new EssenceBootsItem(ModArmorMaterials.LIGHTIUM, 520, 8, 2));
        TORNIUM_HELMET = REGISTRY.register("tornium_helmet", () -> new EssenceHelmetItem(ModArmorMaterials.TORNIUM, 620, 9, 2));
        TORNIUM_CHESTPLATE = REGISTRY.register("tornium_chestplate", () -> new EssenceChestplateItem(ModArmorMaterials.TORNIUM, 620, 9, 2));
        TORNIUM_LEGGINGS = REGISTRY.register("tornium_leggings", () -> new EssenceLeggingsItem(ModArmorMaterials.TORNIUM, 620, 9, 2));
        TORNIUM_BOOTS = REGISTRY.register("tornium_boots", () -> new EssenceBootsItem(ModArmorMaterials.TORNIUM, 620, 9, 2));
        OURANIUM_HELMET = REGISTRY.register("ouranium_helmet", () -> new EssenceHelmetItem(ModArmorMaterials.OURANIUM, 820, 10, 2));
        OURANIUM_CHESTPLATE = REGISTRY.register("ouranium_chestplate", () -> new EssenceChestplateItem(ModArmorMaterials.OURANIUM, 820, 10, 2));
        OURANIUM_LEGGINGS = REGISTRY.register("ouranium_leggings", () -> new EssenceLeggingsItem(ModArmorMaterials.OURANIUM, 820, 10, 2));
        OURANIUM_BOOTS = REGISTRY.register("ouranium_boots", () -> new EssenceBootsItem(ModArmorMaterials.OURANIUM, 820, 10, 2));
    }
}

