/*
 * Decompiled with CFR 0.152.
 */
package velvet.mysticalextendedtier.lib;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import velvet.mysticalextendedtier.util.MysticalExtendedTags;

public enum ModItemTier implements Tier
{
    ORNIUM(MysticalExtendedTags.Blocks.INCORRECT_FOR_ORNIUM_TOOL, 0, 35.0f, 30.0f, 24, () -> {
        Item item = (Item)BuiltInRegistries.ITEM.get(MysticalAgricultureAPI.resource((String)"ornium_ingot"));
        return Ingredient.of((ItemLike[])new ItemLike[]{item});
    }),
    LIGHTIUM(MysticalExtendedTags.Blocks.INCORRECT_FOR_LIGHTIUM_TOOL, 0, 40.0f, 35.0f, 26, () -> {
        Item item = (Item)BuiltInRegistries.ITEM.get(MysticalAgricultureAPI.resource((String)"lightium_ingot"));
        return Ingredient.of((ItemLike[])new ItemLike[]{item});
    }),
    TORNIUM(MysticalExtendedTags.Blocks.INCORRECT_FOR_TORNIUM_TOOL, 0, 45.0f, 40.0f, 28, () -> {
        Item item = (Item)BuiltInRegistries.ITEM.get(MysticalAgricultureAPI.resource((String)"tornium_ingot"));
        return Ingredient.of((ItemLike[])new ItemLike[]{item});
    }),
    OURANIUM(MysticalExtendedTags.Blocks.INCORRECT_FOR_OURANIUM_TOOL, 0, 50.0f, 45.0f, 30, () -> {
        Item item = (Item)BuiltInRegistries.ITEM.get(MysticalAgricultureAPI.resource((String)"ouranium_ingot"));
        return Ingredient.of((ItemLike[])new ItemLike[]{item});
    });

    private final TagKey<Block> incorrectBlocksForDrops;
    private final int maxUses;
    private final float efficiency;
    private final float attackDamage;
    private final int enchantability;
    private final Supplier<Ingredient> repairMaterial;

    private ModItemTier(TagKey<Block> incorrectBlocksForDrops, int maxUses, float efficiency, float attackDamage, int enchantability, Supplier<Ingredient> repairMaterial) {
        this.incorrectBlocksForDrops = incorrectBlocksForDrops;
        this.maxUses = maxUses;
        this.efficiency = efficiency;
        this.attackDamage = attackDamage;
        this.enchantability = enchantability;
        this.repairMaterial = Suppliers.memoize(repairMaterial::get);
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public int getUses() {
        return this.maxUses;
    }

    public float getSpeed() {
        return this.efficiency;
    }

    public float getAttackDamageBonus() {
        return this.attackDamage;
    }

    public int getEnchantmentValue() {
        return this.enchantability;
    }

    public Ingredient getRepairIngredient() {
        return this.repairMaterial.get();
    }
}

