/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips.tooltip;

import com.anthonyhilyard.iceberg.util.Easing;
import com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig;
import com.google.common.collect.Maps;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.DeltaTracker;

public final class TooltipScroll {
    private static final float scrollDuration = 0.15f;
    private static final float overScroll = 3.0f;
    private static Map<Integer, ScrollData> dataMap = Maps.newHashMap();

    private TooltipScroll() {
    }

    public static void setScrollBounds(int index, float top, float bottom) {
        ScrollData data = dataMap.computeIfAbsent(index, k -> new ScrollData());
        data.scrollTop = top;
        data.scrollBottom = bottom;
    }

    public static void setContentHeight(int index, float height) {
        TooltipScroll.dataMap.computeIfAbsent((Integer)Integer.valueOf((int)index), (Function<Integer, ScrollData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setContentHeight$1(java.lang.Integer ), (Ljava/lang/Integer;)Lcom/anthonyhilyard/legendarytooltips/tooltip/TooltipScroll$ScrollData;)()).contentHeight = height;
    }

    public static void setTooltipVisible(int index, boolean visible) {
        TooltipScroll.dataMap.computeIfAbsent((Integer)Integer.valueOf((int)index), (Function<Integer, ScrollData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setTooltipVisible$2(java.lang.Integer ), (Ljava/lang/Integer;)Lcom/anthonyhilyard/legendarytooltips/tooltip/TooltipScroll$ScrollData;)()).tooltipVisible = visible;
    }

    public static boolean isTooltipVisible(int index) {
        return TooltipScroll.dataMap.computeIfAbsent((Integer)Integer.valueOf((int)index), (Function<Integer, ScrollData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$isTooltipVisible$3(java.lang.Integer ), (Ljava/lang/Integer;)Lcom/anthonyhilyard/legendarytooltips/tooltip/TooltipScroll$ScrollData;)()).tooltipVisible;
    }

    public static float getScrollTop(int index) {
        return TooltipScroll.dataMap.computeIfAbsent((Integer)Integer.valueOf((int)index), (Function<Integer, ScrollData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getScrollTop$4(java.lang.Integer ), (Ljava/lang/Integer;)Lcom/anthonyhilyard/legendarytooltips/tooltip/TooltipScroll$ScrollData;)()).scrollTop;
    }

    public static float getScrollBottom(int index) {
        return TooltipScroll.dataMap.computeIfAbsent((Integer)Integer.valueOf((int)index), (Function<Integer, ScrollData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getScrollBottom$5(java.lang.Integer ), (Ljava/lang/Integer;)Lcom/anthonyhilyard/legendarytooltips/tooltip/TooltipScroll$ScrollData;)()).scrollBottom;
    }

    public static float currentScroll(int index) {
        return TooltipScroll.dataMap.computeIfAbsent((Integer)Integer.valueOf((int)index), (Function<Integer, ScrollData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$currentScroll$6(java.lang.Integer ), (Ljava/lang/Integer;)Lcom/anthonyhilyard/legendarytooltips/tooltip/TooltipScroll$ScrollData;)()).scrollOffset;
    }

    public static void reset(int index) {
        dataMap.put(index, new ScrollData());
    }

    public static void resetAll() {
        dataMap.clear();
    }

    public static void scroll(float amount) {
        for (ScrollData data : dataMap.values()) {
            data.prevTargetOffset = data.scrollOffset;
            data.targetOffset += amount * LegendaryTooltipsConfig.getInstance().scrollSpeed.get().floatValue();
            data.targetOffset = Math.clamp(data.targetOffset, -3.0f, data.getScrollableHeight() + 3.0f);
            data.prevTargetOffset = Math.clamp(data.prevTargetOffset, 0.0f, data.contentHeight);
            data.scrollTimer = 0.0f;
        }
    }

    public static void onRenderTick(DeltaTracker tracker) {
        for (ScrollData data : dataMap.values()) {
            if (data.targetOffset == data.scrollOffset) continue;
            data.scrollTimer += tracker.getRealtimeDeltaTicks() * 0.05f;
            if (data.scrollTimer < 0.15f) {
                float alpha = data.scrollTimer / 0.15f;
                data.scrollOffset = Easing.Ease((float)data.prevTargetOffset, (float)data.targetOffset, (float)alpha, (Easing.EasingType)Easing.EasingType.Quad, (Easing.EasingDirection)Easing.EasingDirection.Out);
                continue;
            }
            data.scrollOffset = data.targetOffset;
            data.scrollTimer = 0.0f;
            data.prevTargetOffset = data.targetOffset;
            data.targetOffset = Math.clamp(data.targetOffset, 0.0f, data.getScrollableHeight());
        }
    }

    private static /* synthetic */ ScrollData lambda$currentScroll$6(Integer k) {
        return new ScrollData();
    }

    private static /* synthetic */ ScrollData lambda$getScrollBottom$5(Integer k) {
        return new ScrollData();
    }

    private static /* synthetic */ ScrollData lambda$getScrollTop$4(Integer k) {
        return new ScrollData();
    }

    private static /* synthetic */ ScrollData lambda$isTooltipVisible$3(Integer k) {
        return new ScrollData();
    }

    private static /* synthetic */ ScrollData lambda$setTooltipVisible$2(Integer k) {
        return new ScrollData();
    }

    private static /* synthetic */ ScrollData lambda$setContentHeight$1(Integer k) {
        return new ScrollData();
    }

    private static class ScrollData {
        public float scrollOffset = 0.0f;
        public float targetOffset = 0.0f;
        public float prevTargetOffset = 0.0f;
        public float scrollTimer = 0.0f;
        public float scrollTop = 0.0f;
        public float scrollBottom = 0.0f;
        public float contentHeight = 0.0f;
        public boolean tooltipVisible = false;

        private ScrollData() {
        }

        public float getScrollableHeight() {
            return Math.max(this.contentHeight - Math.max(this.scrollBottom - this.scrollTop, 0.0f), 0.0f);
        }
    }
}

