/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.item;

import cy.jdkdigital.utilitarian.module.NoSolicitingModule;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class RestrainingOrder
extends Item {
    public RestrainingOrder(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pPlayer.isShiftKeyDown()) {
            this.toggleActive(pPlayer.getItemInHand(pUsedHand));
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (RestrainingOrder.isActive(pStack)) {
            pTooltipComponents.add((Component)Component.translatable((String)"utilitarian.restraining_order.status.active").withStyle(ChatFormatting.GOLD));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)"utilitarian.restraining_order.status.inactive").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }

    private void toggleActive(ItemStack stack) {
        Boolean active = (Boolean)stack.get(NoSolicitingModule.ACTIVE);
        if (active != null) {
            stack.set(NoSolicitingModule.ACTIVE, (Object)(active == false ? 1 : 0));
        } else {
            stack.set(NoSolicitingModule.ACTIVE, (Object)true);
        }
    }

    public static boolean isActive(ItemStack stack) {
        Boolean active = (Boolean)stack.get(NoSolicitingModule.ACTIVE);
        return active != null && active != false;
    }

    public static boolean isEnabledRestrainingOrder(ItemStack itemStack) {
        return itemStack.is((Item)NoSolicitingModule.RESTRAINING_ORDER.get()) && RestrainingOrder.isActive(itemStack);
    }
}

