/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.create;

import com.blakebr0.cucumber.helper.ParsingHelper;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalcustomization.loader.CropTierLoader;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public final class CropTierCreator {
    public static CropTier create(ResourceLocation id, JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        int value = GsonHelper.getAsInt((JsonObject)json, (String)"value");
        String colorString = GsonHelper.getAsString((JsonObject)json, (String)"color", (String)"ffffff");
        int color = ParsingHelper.parseHex((String)colorString, (String)"color");
        CropTier tier = new CropTier(id, value, color, ChatFormatting.WHITE);
        if (json.has("name")) {
            String name = GsonHelper.getAsString((JsonObject)json, (String)"name");
            tier.setDisplayName(Component.literal((String)name));
        }
        if (json.has("fertilizable")) {
            boolean fertilizable = GsonHelper.getAsBoolean((JsonObject)json, (String)"fertilizable");
            tier.setFertilizable(fertilizable);
        }
        if (json.has("secondarySeedDrop")) {
            boolean secondarySeedDrop = GsonHelper.getAsBoolean((JsonObject)json, (String)"secondarySeedDrop");
            tier.setSecondarySeedDrop(secondarySeedDrop);
        }
        if (json.has("baseSecondaryChance")) {
            double chance = GsonHelper.getAsDouble((JsonObject)json, (String)"baseSecondaryChance");
            tier.setBaseSecondaryChance(chance);
        }
        if (json.has("farmland")) {
            String blockId = GsonHelper.getAsString((JsonObject)json, (String)"farmland");
            CropTierLoader.FARMLAND_MAP.put(tier, ResourceLocation.parse((String)blockId));
        }
        if (json.has("essence")) {
            String itemId = GsonHelper.getAsString((JsonObject)json, (String)"essence");
            CropTierLoader.ESSENCE_MAP.put(tier, ResourceLocation.parse((String)itemId));
        }
        return tier;
    }
}

