/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodBlock;
import owmii.powah.config.v2.types.EnergyConfig;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.util.NBT;
import owmii.powah.util.Ticker;

public class EnergizingRodTile
extends AbstractEnergyStorage<EnergyConfig, EnergizingRodBlock> {
    private BlockPos orbPos = BlockPos.ZERO;
    public final Ticker coolDown = new Ticker(20.0);

    public EnergizingRodTile(BlockPos pos, BlockState state, Tier variant) {
        super(Tiles.ENERGIZING_ROD.get(), pos, state, variant);
    }

    public EnergizingRodTile(BlockPos pos, BlockState state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void readSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.readSync(nbt, registries);
        this.orbPos = NBT.readPos(nbt, "OrbPos");
    }

    @Override
    public CompoundTag writeSync(CompoundTag nbt, HolderLookup.Provider registries) {
        NBT.writePos(nbt, this.orbPos, "OrbPos");
        return super.writeSync(nbt, registries);
    }

    @Override
    protected int postTick(Level world) {
        boolean flag = false;
        EnergizingOrbTile orb = this.getOrbTile();
        if (orb != null) {
            if (orb.containRecipe() && this.energy.hasEnergy()) {
                this.coolDown.onward();
                flag = true;
            } else if (this.coolDown.getTicks() > 0.0) {
                this.coolDown.back();
                flag = true;
            }
            if (this.coolDown.ended()) {
                long fill = Math.min(this.energy.getEnergyStored(), ((EnergizingRodBlock)this.getBlock()).getConfig().getTransfer((Tier)this.getVariant()));
                this.energy.consume(orb.fillEnergy(fill));
                flag = true;
            }
        }
        return flag ? 10 : -1;
    }

    @Nullable
    public EnergizingOrbTile getOrbTile() {
        BlockEntity tile;
        if (this.level != null && this.orbPos != BlockPos.ZERO && this.level.isLoaded(this.orbPos) && (tile = this.level.getBlockEntity(this.orbPos)) instanceof EnergizingOrbTile) {
            return (EnergizingOrbTile)tile;
        }
        return null;
    }

    public boolean hasOrb() {
        return this.getOrbTile() != null;
    }

    public BlockPos getOrbPos() {
        return this.orbPos;
    }

    public void setOrbPos(BlockPos orbPos) {
        this.orbPos = orbPos;
        this.sync(2);
    }

    @Override
    public boolean keepEnergy() {
        return true;
    }

    @Override
    public boolean isEnergyPresent(@Nullable Direction side) {
        return side != null && side.equals((Object)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
    }
}

