/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import owmii.powah.Powah;
import owmii.powah.api.MagmatorFuelValue;

public record MagmatorFuel(ResourceLocation id, Fluid fluid, Set<BucketItem> buckets, int heat) {
    public static List<MagmatorFuel> getAll() {
        ArrayList<MagmatorFuel> result = new ArrayList<MagmatorFuel>();
        Map dataMap = BuiltInRegistries.FLUID.getDataMap(MagmatorFuelValue.DATA_MAP_TYPE);
        for (Map.Entry entry : dataMap.entrySet()) {
            ResourceLocation id = ((ResourceKey)entry.getKey()).location();
            MagmatorFuelValue heat = (MagmatorFuelValue)entry.getValue();
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(id);
            if (!fluid.isSource(fluid.defaultFluidState())) continue;
            HashSet<BucketItem> buckets = new HashSet<BucketItem>();
            Item bucket = fluid.getBucket();
            if (bucket instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)bucket;
                if (bucketItem.content == fluid) {
                    buckets.add(bucketItem);
                }
            }
            result.add(new MagmatorFuel(Powah.id("magmator_fuel/" + id.getNamespace() + "/" + id.getPath()), fluid, buckets, heat.energyProduced()));
        }
        result.sort(Comparator.comparingInt(MagmatorFuel::heat));
        return result;
    }
}

