/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.jei;

import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import owmii.powah.block.Blcks;
import owmii.powah.block.energizing.EnergizingRecipe;
import owmii.powah.compat.jei.AbstractCategory;
import owmii.powah.compat.jei.Assets;
import owmii.powah.recipe.Recipes;
import owmii.powah.util.Util;

public class JeiEnergizingCategory
extends AbstractCategory<RecipeHolder<EnergizingRecipe>> {
    public static final Supplier<RecipeType<RecipeHolder<EnergizingRecipe>>> TYPE = RecipeType.createFromDeferredVanilla(Recipes.ENERGIZING);

    public JeiEnergizingCategory(IGuiHelper guiHelper) {
        super(guiHelper, (ItemLike)Blcks.ENERGIZING_ORB.get(), (Component)Component.translatable((String)"gui.powah.jei.category.energizing"), (IDrawable)guiHelper.drawableBuilder(Assets.ENERGIZING, 0, 0, 160, 38).addPadding(1, 0, 0, 0).build());
    }

    public RecipeType<RecipeHolder<EnergizingRecipe>> getRecipeType() {
        return TYPE.get();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<EnergizingRecipe> recipeHolder, IFocusGroup focuses) {
        EnergizingRecipe recipe = (EnergizingRecipe)recipeHolder.value();
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        int size = ingredients.size();
        for (int i = 0; i < size; ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, i * 20 + 4, 5).addIngredients((Ingredient)ingredients.get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 137, 5).addItemStack(recipe.getResultItem());
    }

    public void draw(RecipeHolder<EnergizingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        EnergizingRecipe recipe = (EnergizingRecipe)recipeHolder.value();
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.drawString(minecraft.font, I18n.get((String)"info.lollipop.fe", (Object[])new Object[]{Util.addCommas(recipe.getEnergy())}), 2, 29, 0x444444, false);
    }

    public static List<RecipeHolder<EnergizingRecipe>> getAllRecipes() {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        assert (level != null);
        RecipeManager recipeManager = level.getRecipeManager();
        return recipeManager.getAllRecipesFor(Recipes.ENERGIZING.get());
    }
}

