/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.logistics.inventory.slot;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import owmii.powah.lib.logistics.inventory.ItemStackHandler;

public class SlotItemHandler
extends Slot {
    private static Container emptyInventory = new SimpleContainer(0);
    private final ItemStackHandler itemHandler;

    public SlotItemHandler(ItemStackHandler itemHandler, int index, int xPosition, int yPosition) {
        super(emptyInventory, index, xPosition, yPosition);
        this.itemHandler = itemHandler;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return this.itemHandler.isItemValid(this.index, stack);
    }

    @NotNull
    public ItemStack getItem() {
        return this.getItemHandler().getStackInSlot(this.index);
    }

    public void set(@NotNull ItemStack stack) {
        this.getItemHandler().setStackInSlot(this.index, stack);
        this.setChanged();
    }

    public void initialize(ItemStack stack) {
        this.getItemHandler().setStackInSlot(this.index, stack);
    }

    public void onQuickCraft(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
    }

    public int getMaxStackSize() {
        return this.itemHandler.getSlotLimit(this.index);
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        ItemStack maxAdd = stack.copy();
        int maxInput = stack.getMaxStackSize();
        maxAdd.setCount(maxInput);
        ItemStackHandler handler = this.getItemHandler();
        ItemStack currentStack = handler.getStackInSlot(this.index);
        handler.setStackInSlot(this.index, ItemStack.EMPTY);
        ItemStack remainder = handler.insertItem(this.index, maxAdd, true);
        handler.setStackInSlot(this.index, currentStack);
        return maxInput - remainder.getCount();
    }

    public boolean mayPickup(Player playerIn) {
        return !this.getItemHandler().extractItem(this.index, 1, true).isEmpty();
    }

    @NotNull
    public ItemStack remove(int amount) {
        return this.getItemHandler().extractItem(this.index, amount, false);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }
}

