/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import owmii.powah.lib.registry.IVariant;

public class VarReg<V extends Enum<V>, E> {
    private static final Map<String, List<String>> ALL_VARIANTS = new HashMap<String, List<String>>();
    private final LinkedHashMap<V, Supplier<E>> all = new LinkedHashMap();

    public static List<String> getSiblingIds(String name) {
        return ALL_VARIANTS.getOrDefault(name, List.of(name));
    }

    public VarReg(DeferredRegister<E> dr, String name, VariantConstructor<V, E> ctor, V[] variants) {
        for (Object variant : variants) {
            String entryName = name + "_" + ((IVariant)variant).getName();
            ALL_VARIANTS.computeIfAbsent(name, s -> new ArrayList()).add(entryName);
            this.all.put((DeferredHolder)variant, (Supplier<E>)dr.register(entryName, () -> ctor.get(variant)));
        }
    }

    public E[] getArr(IntFunction<E[]> generator) {
        A[] es = this.getAll().stream().toArray(generator);
        return es;
    }

    public List<E> getAll() {
        return this.all.values().stream().map(Supplier::get).toList();
    }

    public E get(V variant) {
        return this.all.get(variant).get();
    }

    @FunctionalInterface
    public static interface VariantConstructor<V extends Enum<V>, E> {
        public E get(V var1);
    }
}

