/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class BaseProperties {
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
    private final Path path;
    private final String name;
    protected JsonObject properties;
    private boolean writeProperties;

    public BaseProperties(Path path, String name) {
        this.path = path;
        this.name = name;
        this.properties = new JsonObject();
        try {
            this.writeProperties = false;
            if (Files.exists(path, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(path);){
                    this.properties = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                }
            } else {
                this.writeProperties = true;
            }
            this.load();
            if (this.writeProperties) {
                this.save();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void load() {
    }

    public void remove(String key) {
        if (this.properties.remove(key) != null) {
            this.writeProperties = true;
        }
    }

    public JsonElement get(String key) {
        JsonElement e = this.properties.get(key);
        return e == null ? JsonNull.INSTANCE : e;
    }

    public String get(String key, String def) {
        JsonElement s = this.get(key);
        if (s.isJsonNull()) {
            this.properties.addProperty(key, def);
            this.writeProperties = true;
            return def;
        }
        return s.getAsString();
    }

    public JsonElement get(String key, JsonElement def) {
        JsonElement s = this.get(key);
        if (s.isJsonNull()) {
            this.properties.add(key, def);
            this.writeProperties = true;
            return def;
        }
        return s;
    }

    public boolean get(String key, boolean def) {
        return this.get(key, (JsonElement)new JsonPrimitive(Boolean.valueOf(def))).getAsBoolean();
    }

    public int get(String key, int def) {
        return this.get(key, (JsonElement)new JsonPrimitive((Number)def)).getAsInt();
    }

    public double get(String key, double def) {
        return this.get(key, (JsonElement)new JsonPrimitive((Number)def)).getAsDouble();
    }

    public void set(String key, JsonElement json) {
        this.properties.add(key, json);
        this.writeProperties = true;
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.path, new OpenOption[0]);){
            GSON.toJson((JsonElement)this.properties, (Appendable)writer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String toString() {
        return this.name;
    }
}

