/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.bindings.event.ClientEvents;
import dev.latvian.mods.kubejs.client.LangKubeEvent;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryObjectStorage;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.GeneratedDataStage;
import dev.latvian.mods.kubejs.script.data.KubeFileResourcePack;
import dev.latvian.mods.kubejs.script.data.VirtualAssetPack;
import dev.latvian.mods.kubejs.util.JsonUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.neoforged.fml.loading.FMLLoader;

public class ClientAssetPacks {
    public static final ClientAssetPacks INSTANCE = new ClientAssetPacks();
    public final VirtualAssetPack internalAssetPack = new VirtualAssetPack(GeneratedDataStage.INTERNAL);
    public final Map<GeneratedDataStage, VirtualAssetPack> virtualPacks = GeneratedDataStage.forScripts(VirtualAssetPack::new);

    public List<PackResources> inject(List<PackResources> original) {
        try {
            return this.inject0(original);
        }
        catch (Throwable ex) {
            ConsoleJS.CLIENT.error("Error while generating client assets", ex);
            return original;
        }
    }

    private List<PackResources> inject0(List<PackResources> original) {
        ArrayList<PackResources> packs = new ArrayList<PackResources>(original);
        ArrayList<PackResources> filePacks = new ArrayList<PackResources>();
        KubeFileResourcePack.scanAndLoad(KubeJSPaths.ASSETS, filePacks);
        filePacks.sort((p1, p2) -> p1.packId().compareToIgnoreCase(p2.packId()));
        filePacks.add(new KubeFileResourcePack(PackType.CLIENT_RESOURCES));
        int beforeModsIndex = KubeFileResourcePack.findBeforeModsIndex(packs);
        int afterModsIndex = KubeFileResourcePack.findAfterModsIndex(packs);
        packs.add(beforeModsIndex, this.virtualPacks.get((Object)GeneratedDataStage.BEFORE_MODS));
        packs.add(afterModsIndex, this.internalAssetPack);
        packs.add(afterModsIndex + 1, this.virtualPacks.get((Object)GeneratedDataStage.AFTER_MODS));
        packs.addAll(afterModsIndex + 2, filePacks);
        packs.add(this.virtualPacks.get((Object)GeneratedDataStage.LAST));
        this.internalAssetPack.reset();
        for (BuilderBase<?> builder : RegistryObjectStorage.ALL_BUILDERS) {
            builder.generateAssets(this.internalAssetPack);
        }
        KubeJSPlugins.forEachPlugin(this.internalAssetPack, KubeJSPlugin::generateAssets);
        this.internalAssetPack.buildSounds();
        HashMap<LangKubeEvent.Key, String> langMap = new HashMap<LangKubeEvent.Key, String>();
        HashMap<String, LangKubeEvent> langEvents = new HashMap<String, LangKubeEvent>();
        LangKubeEvent enUsLangEvent = langEvents.computeIfAbsent("en_us", s -> new LangKubeEvent((String)s, (Map<LangKubeEvent.Key, String>)langMap));
        for (BuilderBase<?> builder : RegistryObjectStorage.ALL_BUILDERS) {
            builder.generateLang(enUsLangEvent);
        }
        KubeJSPlugins.forEachPlugin(enUsLangEvent, KubeJSPlugin::generateLang);
        ClientEvents.GENERATE_ASSETS.post(ScriptType.CLIENT, GeneratedDataStage.AFTER_MODS, this.virtualPacks.get((Object)GeneratedDataStage.AFTER_MODS));
        for (String lang : ClientEvents.LANG.findUniqueExtraIds(ScriptType.CLIENT)) {
            String l = String.valueOf(lang);
            if (LangKubeEvent.PATTERN.matcher(l).matches()) {
                ClientEvents.LANG.post(ScriptType.CLIENT, l, langEvents.computeIfAbsent(l, k -> new LangKubeEvent((String)k, (Map<LangKubeEvent.Key, String>)langMap)));
                continue;
            }
            ConsoleJS.CLIENT.error("Invalid language key: " + l);
        }
        try {
            for (Path dir : Files.list(KubeJSPaths.ASSETS).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toList()) {
                String ns = dir.getFileName().toString();
                Path langDir = dir.resolve("lang");
                if (!Files.exists(langDir, new LinkOption[0]) || !Files.isDirectory(langDir, new LinkOption[0])) continue;
                for (Path path : Files.list(langDir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Files::isReadable).toList()) {
                    String fileName = path.getFileName().toString();
                    if (!fileName.endsWith(".json")) continue;
                    try {
                        BufferedReader reader = Files.newBufferedReader(path);
                        try {
                            JsonObject json = (JsonObject)JsonUtils.GSON.fromJson((Reader)reader, JsonObject.class);
                            String lang = fileName.substring(0, fileName.length() - 5);
                            for (Map.Entry entry : json.entrySet()) {
                                langMap.put(new LangKubeEvent.Key(ns, lang, (String)entry.getKey()), ((JsonElement)entry.getValue()).getAsString());
                            }
                        }
                        finally {
                            if (reader == null) continue;
                            reader.close();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        HashMap<String, Map> finalMap = new HashMap<String, Map>();
        for (Map.Entry entry : langMap.entrySet()) {
            Map ns = finalMap.computeIfAbsent(((LangKubeEvent.Key)entry.getKey()).namespace(), s -> new HashMap());
            JsonObject lang = ns.computeIfAbsent(((LangKubeEvent.Key)entry.getKey()).lang(), s -> new JsonObject());
            lang.addProperty(((LangKubeEvent.Key)entry.getKey()).key(), (String)entry.getValue());
        }
        for (Map.Entry e1 : finalMap.entrySet()) {
            for (Map.Entry e2 : ((Map)e1.getValue()).entrySet()) {
                this.internalAssetPack.json(ResourceLocation.parse((String)((String)e1.getKey() + ":lang/" + (String)e2.getKey())), (JsonElement)e2.getValue());
            }
        }
        for (VirtualAssetPack pack : this.virtualPacks.values()) {
            pack.reset();
            if (!ClientEvents.GENERATE_ASSETS.hasListeners(pack.stage)) continue;
            ClientEvents.GENERATE_ASSETS.post(ScriptType.CLIENT, pack.stage, pack);
        }
        if (!FMLLoader.isProduction()) {
            KubeJS.LOGGER.info("Loaded " + packs.size() + " asset packs: " + packs.stream().map(PackResources::packId).collect(Collectors.joining(", ")));
        }
        return packs;
    }
}

