/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.event;

import dev.latvian.mods.kubejs.event.EventExit;
import java.util.function.Consumer;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;

public class EventResult {
    public static final EventResult PASS = Type.PASS.defaultResult;
    private final Type type;
    private final Object value;

    private EventResult(Type type, @Nullable Object value) {
        this.type = type;
        this.value = value;
    }

    public Type type() {
        return this.type;
    }

    public Object value() {
        return this.value;
    }

    public boolean override() {
        return this.type != Type.PASS;
    }

    public boolean pass() {
        return this.type == Type.PASS;
    }

    public boolean interruptDefault() {
        return this.type == Type.INTERRUPT_DEFAULT;
    }

    public boolean interruptFalse() {
        return this.type == Type.INTERRUPT_FALSE;
    }

    public boolean interruptTrue() {
        return this.type == Type.INTERRUPT_TRUE;
    }

    public boolean applyCancel(ICancellableEvent event) {
        if (this.interruptFalse()) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    public void applyTristate(Consumer<TriState> consumer) {
        if (this.interruptFalse()) {
            consumer.accept(TriState.FALSE);
        } else if (this.interruptTrue()) {
            consumer.accept(TriState.TRUE);
        }
    }

    public static enum Type {
        ERROR,
        PASS,
        INTERRUPT_DEFAULT,
        INTERRUPT_FALSE,
        INTERRUPT_TRUE;

        public final EventResult defaultResult = new EventResult(this, null);
        public final EventExit defaultExit = new EventExit(this.defaultResult);

        public EventExit exit(@Nullable Object value) {
            return value == null ? this.defaultExit : new EventExit(new EventResult(this, value));
        }
    }
}

