/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.bindings.BlockWrapper;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public record BlockComponent() implements RecipeComponent<Block>
{
    public static final RecipeComponent<Block> BLOCK = new BlockComponent();

    @Override
    public Codec<Block> codec() {
        return BuiltInRegistries.BLOCK.byNameCodec();
    }

    @Override
    public TypeInfo typeInfo() {
        return TypeInfo.of(Block.class);
    }

    @Override
    public Block wrap(Context cx, KubeRecipe recipe, Object from) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Block.class, BlockState.class, JsonPrimitive.class}, (Object)object, n)) {
            case 0 -> {
                Block b;
                yield b = (Block)object;
            }
            case 1 -> {
                BlockState s = (BlockState)object;
                yield s.getBlock();
            }
            case 2 -> {
                JsonPrimitive json = (JsonPrimitive)object;
                yield BlockWrapper.parseBlockState(RegistryAccessContainer.of(cx), json.getAsString()).getBlock();
            }
            default -> BlockWrapper.parseBlockState(RegistryAccessContainer.of(cx), String.valueOf(from)).getBlock();
        };
    }

    @Override
    public boolean matches(Context cx, KubeRecipe recipe, Block value, ReplacementMatchInfo match) {
        BlockStatePredicate m2;
        ReplacementMatch replacementMatch = match.match();
        return replacementMatch instanceof BlockStatePredicate && (m2 = (BlockStatePredicate)replacementMatch).testBlock(value);
    }

    @Override
    public boolean isEmpty(Block value) {
        return value == Blocks.AIR;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, Block value) {
        builder.append(value.kjs$getIdLocation());
    }

    @Override
    public String toString() {
        return "block";
    }
}

