/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.filter;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import dev.latvian.mods.kubejs.core.RecipeLikeKJS;
import dev.latvian.mods.kubejs.recipe.filter.RecipeFilter;
import dev.latvian.mods.rhino.Context;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;

public class RegexIDFilter
implements RecipeFilter {
    private final Pattern pattern;
    private final ConcurrentHashMap<ResourceLocation, Boolean> matchCache = new ConcurrentHashMap();
    private static Interner<RegexIDFilter> INTERNER;

    private RegexIDFilter(Pattern i) {
        this.pattern = i;
    }

    public static RegexIDFilter of(Pattern i) {
        return (RegexIDFilter)INTERNER.intern((Object)new RegexIDFilter(i));
    }

    public static void clearInternCache() {
        INTERNER = Interners.newStrongInterner();
    }

    @Override
    public boolean test(Context cx, RecipeLikeKJS recipe) {
        return this.matchCache.computeIfAbsent(recipe.kjs$getOrCreateId(), location -> this.pattern.matcher(location.toString()).find());
    }

    public String toString() {
        return "RegexIDFilter{pattern=" + String.valueOf(this.pattern) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexIDFilter that = (RegexIDFilter)o;
        return this.pattern.pattern().equals(that.pattern.pattern()) && this.pattern.flags() == that.pattern.flags();
    }

    public int hashCode() {
        return Objects.hash(this.pattern.pattern(), this.pattern.flags());
    }

    static {
        RegexIDFilter.clearInternCache();
    }
}

