/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.core.RegistryObjectKJS;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.UnaryOperator;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface ID {
    public static final ResourceLocation UNKNOWN = ResourceLocation.fromNamespaceAndPath((String)"unknown", (String)"unknown");
    public static final UnaryOperator<String> BLOCKSTATE = s -> "blockstates/" + s;
    public static final UnaryOperator<String> BLOCK = s -> "block/" + s;
    public static final UnaryOperator<String> ITEM = s -> "item/" + s;
    public static final UnaryOperator<String> MODEL = s -> "models/" + s;
    public static final UnaryOperator<String> BLOCK_MODEL = s -> "models/block/" + s;
    public static final UnaryOperator<String> ITEM_MODEL = s -> "models/item/" + s;
    public static final UnaryOperator<String> BLOCK_LOOT_TABLE = s -> "loot_table/blocks/" + s;
    public static final UnaryOperator<String> PNG_TEXTURE = s -> "textures/" + s + ".png";
    public static final UnaryOperator<String> PNG_TEXTURE_MCMETA = s -> "textures/" + s + ".png.mcmeta";
    public static final UnaryOperator<String> PARTICLE = s -> "particles/" + s;

    public static String string(@Nullable String id) {
        if (id == null || id.isEmpty()) {
            return "";
        }
        if (id.indexOf(58) == -1) {
            return "minecraft:" + id;
        }
        return id;
    }

    public static String kjsString(String id) {
        if (id == null || id.isEmpty()) {
            return "";
        }
        if (id.indexOf(58) == -1) {
            return "kubejs:" + id;
        }
        return id;
    }

    public static String namespace(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "minecraft";
        }
        int i = s.indexOf(58);
        return i == -1 ? "minecraft" : s.substring(0, i);
    }

    public static String path(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "air";
        }
        int i = s.indexOf(58);
        return i == -1 ? s : s.substring(i + 1);
    }

    public static ResourceLocation of(@Nullable Object o, boolean preferKJS) {
        Object s;
        if (o == null) {
            return null;
        }
        if (o instanceof ResourceLocation) {
            ResourceLocation id = (ResourceLocation)o;
            return id;
        }
        if (o instanceof ResourceKey) {
            ResourceKey key = (ResourceKey)o;
            return key.location();
        }
        if (o instanceof Holder) {
            Holder holder = (Holder)o;
            return holder.getKey().location();
        }
        if (o instanceof RegistryObjectKJS) {
            RegistryObjectKJS key = (RegistryObjectKJS)o;
            return key.kjs$getIdLocation();
        }
        if (o instanceof JsonPrimitive) {
            JsonPrimitive p = (JsonPrimitive)o;
            v0 = p.getAsString();
        } else {
            v0 = s = o.toString();
        }
        if (((String)s).indexOf(58) == -1 && preferKJS) {
            s = "kubejs:" + (String)s;
        }
        try {
            return ResourceLocation.parse((String)s);
        }
        catch (ResourceLocationException ex) {
            throw new IllegalArgumentException("Could not create ID from '%s'!".formatted(s));
        }
    }

    public static ResourceLocation mc(@Nullable Object o) {
        return ID.of(o, false);
    }

    public static ResourceLocation kjs(@Nullable Object o) {
        return ID.of(o, true);
    }

    public static boolean isKey(Object from) {
        return from instanceof CharSequence || from instanceof ResourceLocation || from instanceof ResourceKey;
    }

    public static String url(ResourceLocation id) {
        return URLEncoder.encode(id.getNamespace(), StandardCharsets.UTF_8) + "/" + URLEncoder.encode(id.getPath(), StandardCharsets.UTF_8);
    }
}

