/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.Resource;
import team.lodestar.lodestone.systems.model.obj.IndexedModel;

public abstract class LodestoneParser<M extends IndexedModel> {
    public void startParse(M model) {
        Optional resource = Minecraft.getInstance().getResourceManager().getResource(((IndexedModel)model).getAssetLocation());
        if (resource.isEmpty()) {
            throw new RuntimeException("Lodestone Model" + String.valueOf(((IndexedModel)model).getModelId()) + " not found at " + String.valueOf(((IndexedModel)model).getAssetLocation()));
        }
        try {
            InputStream inputStream = ((Resource)resource.get()).open();
            this.parse(inputStream, model);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing Model file: " + String.valueOf(((IndexedModel)model).getModelId()), e);
        }
    }

    public abstract void parse(InputStream var1, M var2) throws IOException;
}

