/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import team.lodestar.lodestone.registry.common.LodestonePlacementFillers;

public class DimensionPlacementFilter
extends PlacementFilter {
    public static final MapCodec<DimensionPlacementFilter> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)ResourceLocation.CODEC.listOf().fieldOf("dimensions").forGetter(obj -> obj.dimensions.stream().map(ResourceKey::location).collect(Collectors.toList()))).apply((Applicative)codec, r -> new DimensionPlacementFilter(r.stream().map(o -> ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)o)).collect(Collectors.toSet()))));
    private final Set<ResourceKey<Level>> dimensions;

    protected DimensionPlacementFilter(Set<ResourceKey<Level>> dimensions) {
        this.dimensions = dimensions;
    }

    public static DimensionPlacementFilter of(Set<ResourceKey<Level>> dimensions) {
        return new DimensionPlacementFilter(dimensions);
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)LodestonePlacementFillers.DIMENSION.get();
    }

    public static Set<ResourceKey<Level>> fromStrings(List<? extends String> dimensions) {
        return dimensions.stream().map(o -> ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)o))).collect(Collectors.toSet());
    }

    protected boolean shouldPlace(PlacementContext pContext, RandomSource pRandom, BlockPos pPos) {
        ServerLevel level = pContext.getLevel().getLevel();
        return this.dimensions.contains(level.dimension());
    }
}

