/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.PackagedAutoBlockEntities;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.inventory.CraftingProxyItemHandler;
import thelm.packagedauto.item.PackagedAutoItems;
import thelm.packagedauto.menu.CraftingProxyMenu;
import thelm.packagedauto.packet.BeamPacket;
import thelm.packagedauto.packet.DirectionalMarkerPacket;
import thelm.packagedauto.packet.SizedMarkerPacket;

public class CraftingProxyBlockEntity
extends BaseBlockEntity
implements IPackageCraftingMachine,
ISettingsCloneable {
    public static int range = 8;
    public final Cache<UUID, Long> previewTimes = CacheBuilder.newBuilder().initialCapacity(2).expireAfterWrite(60L, TimeUnit.SECONDS).build();
    public DirectionalGlobalPos target;

    public CraftingProxyBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackagedAutoBlockEntities.CRAFTING_PROXY.get(), pos, state);
        this.setItemHandler(new CraftingProxyItemHandler(this));
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"block.packagedauto.crafting_proxy");
    }

    @Override
    public String getConfigTypeName() {
        return "block.packagedauto.crafting_proxy";
    }

    @Override
    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        return this.acceptPackage(recipeInfo, stacks, direction, false);
    }

    @Override
    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction, boolean blocking) {
        IPackageCraftingMachine machine;
        if (!this.isBusy() && (machine = (IPackageCraftingMachine)this.level.getBlockEntity(this.target.blockPos())).acceptPackage(recipeInfo, stacks, this.target.direction(), blocking)) {
            Direction dir = this.target.direction();
            Vec3 source = Vec3.atCenterOf((Vec3i)this.worldPosition);
            Vec3 delta = Vec3.atLowerCornerOf((Vec3i)this.target.blockPos().subtract((Vec3i)this.worldPosition)).add(Vec3.atLowerCornerOf((Vec3i)dir.getNormal()).scale(0.5));
            BeamPacket.sendBeams((ServerLevel)this.level, source, List.of(delta), 0xFF7F00, 6, true, 32.0);
            return true;
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        if (this.target == null) {
            return true;
        }
        BlockPos pos = this.target.blockPos();
        if (!this.level.isLoaded(pos)) {
            return true;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(pos);
        if (blockEntity != null && !(blockEntity instanceof CraftingProxyBlockEntity) && blockEntity instanceof IPackageCraftingMachine) {
            IPackageCraftingMachine machine = (IPackageCraftingMachine)blockEntity;
            return machine.isBusy();
        }
        return true;
    }

    public void sendPreview(ServerPlayer player) {
        long currentTime = this.level.getGameTime();
        Long cachedTime = (Long)this.previewTimes.getIfPresent((Object)player.getUUID());
        if (cachedTime == null || currentTime - cachedTime > 180L) {
            if (this.target != null) {
                Direction dir = this.target.direction();
                Vec3 source = Vec3.atCenterOf((Vec3i)this.worldPosition);
                Vec3 delta = Vec3.atLowerCornerOf((Vec3i)this.target.blockPos().subtract((Vec3i)this.worldPosition)).add(Vec3.atLowerCornerOf((Vec3i)dir.getNormal()).scale(0.5));
                DirectionalMarkerPacket.sendDirectionalMarkers(player, List.of(this.target), 0xFFFF00, 200);
                BeamPacket.sendBeams(player, source, List.of(delta), 0xFFFF00, 200, false);
            }
            Vec3 lowerCorner = Vec3.atLowerCornerOf((Vec3i)this.worldPosition).subtract((double)range, (double)range, (double)range);
            Vec3 size = new Vec3((double)(range * 2 + 1), (double)(range * 2 + 1), (double)(range * 2 + 1));
            SizedMarkerPacket.sendSizedMarker(player, lowerCorner, size, 0xFF7F00, 200);
        }
    }

    @Override
    public ISettingsCloneable.Result loadConfig(CompoundTag nbt, HolderLookup.Provider registries, Player player) {
        ItemStack stack;
        Inventory playerInventory;
        block12: {
            if (!nbt.contains("target")) {
                return ISettingsCloneable.Result.fail((Component)Component.translatable((String)"item.packagedauto.settings_cloner.invalid"));
            }
            int availableCount = 0;
            playerInventory = player.getInventory();
            if (!this.itemHandler.getStackInSlot(0).isEmpty()) {
                if (this.itemHandler.getStackInSlot(0).is(PackagedAutoItems.PROXY_MARKER)) {
                    availableCount += this.itemHandler.getStackInSlot(0).getCount();
                } else {
                    return ISettingsCloneable.Result.fail((Component)Component.translatable((String)"block.packagedauto.crafting_proxy.non_marker_present"));
                }
            }
            if (availableCount < 1) {
                for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
                    stack = playerInventory.getItem(i);
                    if (!stack.isEmpty() && stack.is(PackagedAutoItems.PROXY_MARKER) && stack.isComponentsPatchEmpty()) {
                        availableCount += stack.getCount();
                    }
                    if (availableCount < 1) {
                        continue;
                    }
                    break block12;
                }
                return ISettingsCloneable.Result.fail((Component)Component.translatable((String)"block.packagedauto.crafting_proxy.no_markers"));
            }
        }
        int removedCount = this.itemHandler.getStackInSlot(0).getCount();
        this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
        if (removedCount < 1) {
            for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
                ItemStack stack2 = playerInventory.getItem(i);
                if (!stack2.isEmpty() && stack2.is(PackagedAutoItems.PROXY_MARKER) && stack2.isComponentsPatchEmpty()) {
                    removedCount += stack2.split(1).getCount();
                }
                if (removedCount >= 1) break;
            }
        }
        if (removedCount > 1 && !playerInventory.add(stack = PackagedAutoItems.PROXY_MARKER.toStack(removedCount - 1))) {
            ItemEntity item = new ItemEntity(this.level, player.getX(), player.getY(), player.getZ(), stack);
            item.setThrower((Entity)player);
            this.level.addFreshEntity((Entity)item);
        }
        Tag targetTag = nbt.get("target");
        DirectionalGlobalPos globalPos = (DirectionalGlobalPos)DirectionalGlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)targetTag).result().get();
        ItemStack stack3 = PackagedAutoItems.PROXY_MARKER.toStack();
        DataComponentPatch patch = DataComponentPatch.builder().set((DataComponentType)PackagedAutoDataComponents.MARKER_POS.get(), (Object)globalPos).build();
        stack3.applyComponents(patch);
        this.itemHandler.setStackInSlot(0, stack3);
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(CompoundTag nbt, HolderLookup.Provider registries, Player player) {
        if (this.target == null) {
            return ISettingsCloneable.Result.fail((Component)Component.translatable((String)"block.packagedauto.crafting_proxy.empty"));
        }
        Tag targetTag = (Tag)DirectionalGlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.target).result().get();
        nbt.put("target", targetTag);
        return ISettingsCloneable.Result.success();
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new CraftingProxyMenu(windowId, inventory, this);
    }
}

