/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.PackagedAutoBlockEntities;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.inventory.DistributorItemHandler;
import thelm.packagedauto.item.PackagedAutoItems;
import thelm.packagedauto.menu.DistributorMenu;
import thelm.packagedauto.packet.BeamPacket;
import thelm.packagedauto.packet.DirectionalMarkerPacket;
import thelm.packagedauto.packet.SizedMarkerPacket;
import thelm.packagedauto.recipe.IPositionedProcessingPackageRecipeInfo;
import thelm.packagedauto.util.MiscHelper;

public class DistributorBlockEntity
extends BaseBlockEntity
implements IPackageCraftingMachine,
ISettingsCloneable {
    public static int range = 16;
    public static int refreshInterval = 4;
    public final Int2ObjectMap<DirectionalGlobalPos> positions = new Int2ObjectArrayMap(81);
    public final Int2ObjectMap<ItemStack> pending = new Int2ObjectArrayMap(81);
    public final Cache<UUID, Long> previewTimes = CacheBuilder.newBuilder().initialCapacity(2).expireAfterWrite(60L, TimeUnit.SECONDS).build();

    public DistributorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackagedAutoBlockEntities.DISTRIBUTOR.get(), pos, state);
        this.setItemHandler(new DistributorItemHandler(this));
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"block.packagedauto.distributor");
    }

    @Override
    public String getConfigTypeName() {
        return "block.packagedauto.distributor";
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide && this.level.getGameTime() % (long)refreshInterval == 0L && !this.pending.isEmpty()) {
            this.distributeItems();
        }
    }

    @Override
    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        return this.acceptPackage(recipeInfo, stacks, direction, false);
    }

    @Override
    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction, boolean blocking) {
        if (!this.isBusy() && recipeInfo instanceof IPositionedProcessingPackageRecipeInfo) {
            IPositionedProcessingPackageRecipeInfo recipe = (IPositionedProcessingPackageRecipeInfo)recipeInfo;
            Int2ObjectMap<ItemStack> matrix = recipe.getMatrix();
            if (!this.positions.keySet().containsAll((IntCollection)matrix.keySet())) {
                return false;
            }
            for (Int2ObjectMap.Entry entry : matrix.int2ObjectEntrySet()) {
                BlockPos pos = ((DirectionalGlobalPos)this.positions.get(entry.getIntKey())).blockPos();
                if (!this.level.isLoaded(pos)) {
                    return false;
                }
                ItemStack stack = ((ItemStack)entry.getValue()).copy();
                Direction dir = ((DirectionalGlobalPos)this.positions.get(entry.getIntKey())).direction();
                IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)dir);
                if (stack.has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && ((IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().hasBlockCapability(this.level, pos, dir)) {
                    if (blocking && !((IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().isEmpty(this.level, pos, dir)) {
                        return false;
                    }
                    if (MiscHelper.INSTANCE.fillVolume(this.level, pos, dir, stack, true).getCount() != stack.getCount()) continue;
                    return false;
                }
                if (itemHandler != null) {
                    if (blocking && !MiscHelper.INSTANCE.isEmpty(itemHandler)) {
                        return false;
                    }
                    if (ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)true).getCount() != stack.getCount()) continue;
                    return false;
                }
                return false;
            }
            for (Int2ObjectMap.Entry entry : matrix.int2ObjectEntrySet()) {
                this.pending.put(entry.getIntKey(), (Object)((ItemStack)entry.getValue()).copy());
            }
            this.distributeItems();
            return true;
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        return !this.pending.isEmpty();
    }

    protected void distributeItems() {
        ArrayList<Vec3> deltas = new ArrayList<Vec3>();
        for (int i : this.pending.keySet().toIntArray()) {
            if (!this.positions.containsKey(i)) {
                this.ejectItems();
                break;
            }
            BlockPos pos = ((DirectionalGlobalPos)this.positions.get(i)).blockPos();
            if (!this.level.isLoaded(pos)) continue;
            ItemStack stack = (ItemStack)this.pending.get(i);
            Direction dir = ((DirectionalGlobalPos)this.positions.get(i)).direction();
            IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)dir);
            ItemStack stackRem = stack;
            if (stack.has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && ((IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().hasBlockCapability(this.level, pos, dir)) {
                stackRem = MiscHelper.INSTANCE.fillVolume(this.level, pos, dir, stack, false);
            } else if (itemHandler != null) {
                stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            } else {
                this.ejectItems();
                break;
            }
            if (stackRem.getCount() < stack.getCount()) {
                Vec3 delta = Vec3.atLowerCornerOf((Vec3i)pos.subtract((Vec3i)this.worldPosition)).add(Vec3.atLowerCornerOf((Vec3i)dir.getNormal()).scale(0.5));
                deltas.add(delta);
            }
            if (stackRem.isEmpty()) {
                this.pending.remove(i);
            } else {
                this.pending.put(i, (Object)stackRem);
            }
            this.setChanged();
        }
        if (!deltas.isEmpty()) {
            Vec3 source = Vec3.atCenterOf((Vec3i)this.worldPosition);
            BeamPacket.sendBeams((ServerLevel)this.level, source, deltas, 65535, 6, true, 32.0);
            this.setChanged();
        }
    }

    protected void ejectItems() {
        for (int i = 0; i < 81; ++i) {
            ItemStack stack;
            if (!this.pending.containsKey(i) || (stack = (ItemStack)this.pending.remove(i)).isEmpty()) continue;
            double dx = (double)(this.level.random.nextFloat() / 2.0f) + 0.25;
            double dy = (double)(this.level.random.nextFloat() / 2.0f) + 0.75;
            double dz = (double)(this.level.random.nextFloat() / 2.0f) + 0.25;
            ItemEntity itemEntity = new ItemEntity(this.level, (double)this.worldPosition.getX() + dx, (double)this.worldPosition.getY() + dy, (double)this.worldPosition.getZ() + dz, stack);
            itemEntity.setDefaultPickUpDelay();
            this.level.addFreshEntity((Entity)itemEntity);
        }
        this.setChanged();
    }

    public void sendPreview(ServerPlayer player) {
        long currentTime = this.level.getGameTime();
        Long cachedTime = (Long)this.previewTimes.getIfPresent((Object)player.getUUID());
        if (cachedTime == null || currentTime - cachedTime > 180L) {
            this.previewTimes.put((Object)player.getUUID(), (Object)currentTime);
            if (!this.positions.isEmpty()) {
                List<Vec3> deltas = this.positions.values().stream().map(globalPos -> {
                    BlockPos pos = globalPos.blockPos();
                    Direction dir = globalPos.direction();
                    return Vec3.atLowerCornerOf((Vec3i)pos.subtract((Vec3i)this.worldPosition)).add(Vec3.atLowerCornerOf((Vec3i)dir.getNormal()).scale(0.5));
                }).collect(Collectors.toList());
                Vec3 source = Vec3.atCenterOf((Vec3i)this.worldPosition);
                DirectionalMarkerPacket.sendDirectionalMarkers(player, new ArrayList<DirectionalGlobalPos>((Collection<DirectionalGlobalPos>)this.positions.values()), 65407, 200);
                BeamPacket.sendBeams(player, source, deltas, 65407, 200, false);
            }
            Vec3 lowerCorner = Vec3.atLowerCornerOf((Vec3i)this.worldPosition).subtract((double)range, (double)range, (double)range);
            Vec3 size = new Vec3((double)(range * 2 + 1), (double)(range * 2 + 1), (double)(range * 2 + 1));
            SizedMarkerPacket.sendSizedMarker(player, lowerCorner, size, 65535, 200);
        }
    }

    @Override
    public int getComparatorSignal() {
        if (!this.pending.isEmpty()) {
            return 15;
        }
        return 0;
    }

    @Override
    public ISettingsCloneable.Result loadConfig(CompoundTag nbt, HolderLookup.Provider registries, Player player) {
        ItemStack stack;
        int i;
        Inventory playerInventory;
        int requiredCount;
        ListTag positionsTag;
        block13: {
            ItemStack stack2;
            int i2;
            positionsTag = nbt.getList("positions", 10);
            if (positionsTag.isEmpty()) {
                return ISettingsCloneable.Result.fail((Component)Component.translatable((String)"item.packagedauto.settings_cloner.invalid"));
            }
            requiredCount = positionsTag.size();
            int availableCount = 0;
            playerInventory = player.getInventory();
            for (i2 = 0; i2 < this.itemHandler.getSlots(); ++i2) {
                stack2 = this.itemHandler.getStackInSlot(i2);
                if (stack2.isEmpty()) continue;
                if (stack2.is(PackagedAutoItems.DISTRIBUTOR_MARKER)) {
                    availableCount += stack2.getCount();
                    continue;
                }
                return ISettingsCloneable.Result.fail((Component)Component.translatable((String)"block.packagedauto.distributor.non_marker_present"));
            }
            if (availableCount < requiredCount) {
                for (i2 = 0; i2 < playerInventory.getContainerSize(); ++i2) {
                    stack2 = playerInventory.getItem(i2);
                    if (!stack2.isEmpty() && stack2.is(PackagedAutoItems.DISTRIBUTOR_MARKER) && stack2.isComponentsPatchEmpty()) {
                        availableCount += stack2.getCount();
                    }
                    if (availableCount < requiredCount) {
                        continue;
                    }
                    break block13;
                }
                return ISettingsCloneable.Result.fail((Component)Component.translatable((String)"block.packagedauto.distributor.no_markers"));
            }
        }
        int removedCount = 0;
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            removedCount += this.itemHandler.getStackInSlot(i).getCount();
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
        if (removedCount < requiredCount) {
            for (i = 0; i < playerInventory.getContainerSize(); ++i) {
                ItemStack stack3 = playerInventory.getItem(i);
                if (!stack3.isEmpty() && stack3.is(PackagedAutoItems.DISTRIBUTOR_MARKER) && stack3.isComponentsPatchEmpty()) {
                    removedCount += stack3.split(requiredCount - removedCount).getCount();
                }
                if (removedCount >= requiredCount) break;
            }
        }
        if (removedCount > requiredCount && !playerInventory.add(stack = PackagedAutoItems.DISTRIBUTOR_MARKER.toStack(removedCount - requiredCount))) {
            ItemEntity item = new ItemEntity(this.level, player.getX(), player.getY(), player.getZ(), stack);
            item.setThrower((Entity)player);
            this.level.addFreshEntity((Entity)item);
        }
        for (int i3 = 0; i3 < requiredCount; ++i3) {
            CompoundTag positionTag = positionsTag.getCompound(i3);
            byte index = positionTag.getByte("index");
            DirectionalGlobalPos globalPos = (DirectionalGlobalPos)DirectionalGlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)positionTag).result().get();
            ItemStack stack4 = PackagedAutoItems.DISTRIBUTOR_MARKER.toStack();
            DataComponentPatch patch = DataComponentPatch.builder().set((DataComponentType)PackagedAutoDataComponents.MARKER_POS.get(), (Object)globalPos).build();
            stack4.applyComponents(patch);
            this.itemHandler.setStackInSlot(index, stack4);
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(CompoundTag nbt, HolderLookup.Provider registries, Player player) {
        if (this.positions.isEmpty()) {
            return ISettingsCloneable.Result.fail((Component)Component.translatable((String)"block.packagedauto.distributor.empty"));
        }
        ListTag positionsTag = new ListTag();
        for (Int2ObjectMap.Entry entry : this.positions.int2ObjectEntrySet()) {
            DirectionalGlobalPos pos = (DirectionalGlobalPos)entry.getValue();
            CompoundTag positionTag = (CompoundTag)DirectionalGlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)pos).result().get();
            positionTag.putByte("index", (byte)entry.getIntKey());
            positionsTag.add((Object)positionTag);
        }
        nbt.put("positions", (Tag)positionsTag);
        return ISettingsCloneable.Result.success();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.pending.clear();
        ArrayList<ItemStack> pendingList = new ArrayList<ItemStack>();
        MiscHelper.INSTANCE.loadAllItems(nbt.getList("pending", 10), pendingList, registries);
        for (int i = 0; i < 81 && i < pendingList.size(); ++i) {
            ItemStack stack = (ItemStack)pendingList.get(i);
            if (stack.isEmpty()) continue;
            this.pending.put(i, (Object)stack);
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        ArrayList<ItemStack> pendingList = new ArrayList<ItemStack>();
        for (int i = 0; i < 81; ++i) {
            pendingList.add((ItemStack)this.pending.getOrDefault(i, (Object)ItemStack.EMPTY));
        }
        ListTag pendingTag = MiscHelper.INSTANCE.saveAllItems(new ListTag(), pendingList, registries);
        nbt.put("pending", (Tag)pendingTag);
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new DistributorMenu(windowId, inventory, this);
    }
}

