/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.PackagedAutoBlockEntities;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.inventory.EncoderItemHandler;
import thelm.packagedauto.inventory.EncoderPatternItemHandler;
import thelm.packagedauto.menu.EncoderMenu;

public class EncoderBlockEntity
extends BaseBlockEntity {
    public static int patternSlots = 20;
    public static Set<String> disabledRecipeTypes = Set.of();
    public final EncoderPatternItemHandler[] patternItemHandlers = new EncoderPatternItemHandler[patternSlots];
    public int patternIndex;

    public EncoderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackagedAutoBlockEntities.ENCODER.get(), pos, state);
        this.setItemHandler(new EncoderItemHandler(this));
        for (int i = 0; i < this.patternItemHandlers.length; ++i) {
            this.patternItemHandlers[i] = new EncoderPatternItemHandler(this);
        }
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"block.packagedauto.encoder");
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        for (EncoderPatternItemHandler inv : this.patternItemHandlers) {
            inv.updateRecipeInfo(false);
        }
    }

    @Override
    public void loadSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadSync(nbt, registries);
        this.patternIndex = nbt.getByte("pattern_index");
        for (int i = 0; i < this.patternItemHandlers.length; ++i) {
            this.patternItemHandlers[i].load(nbt.getCompound(String.format("pattern_%02d", i)), registries);
        }
    }

    @Override
    public CompoundTag saveSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveSync(nbt, registries);
        nbt.putByte("pattern_index", (byte)this.patternIndex);
        for (int i = 0; i < this.patternItemHandlers.length; ++i) {
            CompoundTag subNBT = new CompoundTag();
            this.patternItemHandlers[i].save(subNBT, registries);
            nbt.put(String.format("pattern_%02d", i), (Tag)subNBT);
        }
        return nbt;
    }

    public void setPatternIndex(int patternIndex) {
        this.patternIndex = patternIndex;
        this.sync(false);
        this.setChanged();
    }

    public void saveRecipeList(boolean single) {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!stack.isEmpty()) {
            ArrayList<IPackageRecipeInfo> recipeList = new ArrayList<IPackageRecipeInfo>();
            if (!single) {
                for (EncoderPatternItemHandler inv : this.patternItemHandlers) {
                    if (inv.recipeInfo == null) continue;
                    recipeList.add(inv.recipeInfo);
                }
            } else {
                EncoderPatternItemHandler inv = this.patternItemHandlers[this.patternIndex];
                if (inv.recipeInfo != null) {
                    recipeList.add(inv.recipeInfo);
                }
            }
            DataComponentPatch patch = recipeList.isEmpty() ? DataComponentPatch.builder().remove((DataComponentType)PackagedAutoDataComponents.RECIPE_LIST.get()).build() : DataComponentPatch.builder().set((DataComponentType)PackagedAutoDataComponents.RECIPE_LIST.get(), recipeList).build();
            stack.applyComponents(patch);
        }
    }

    public void loadRecipeList(boolean single, boolean clear) {
        block8: {
            block5: {
                List recipeList;
                block6: {
                    EncoderPatternItemHandler inv;
                    block7: {
                        ItemStack stack = this.itemHandler.getStackInSlot(0);
                        if (!stack.has(PackagedAutoDataComponents.RECIPE_LIST)) break block5;
                        recipeList = (List)stack.get(PackagedAutoDataComponents.RECIPE_LIST);
                        if (!single) break block6;
                        inv = this.patternItemHandlers[this.patternIndex];
                        if (clear || recipeList.isEmpty()) break block7;
                        IPackageRecipeInfo recipe = (IPackageRecipeInfo)recipeList.get(0);
                        inv.recipeType = recipe.getRecipeType();
                        if (!recipe.isValid()) break block8;
                        inv.setRecipe(recipe.getEncoderStacks());
                        break block8;
                    }
                    inv.setRecipe(null);
                    break block8;
                }
                for (int i = 0; i < this.patternItemHandlers.length; ++i) {
                    EncoderPatternItemHandler inv = this.patternItemHandlers[i];
                    if (!clear && i < recipeList.size()) {
                        IPackageRecipeInfo recipe = (IPackageRecipeInfo)recipeList.get(i);
                        inv.recipeType = recipe.getRecipeType();
                        if (!recipe.isValid()) continue;
                        inv.setRecipe(recipe.getEncoderStacks());
                        continue;
                    }
                    inv.setRecipe(null);
                }
                break block8;
            }
            if (single) {
                this.patternItemHandlers[this.patternIndex].setRecipe(null);
            } else {
                for (EncoderPatternItemHandler inv : this.patternItemHandlers) {
                    inv.setRecipe(null);
                }
            }
        }
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new EncoderMenu(windowId, inventory, this);
    }
}

