/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.PackagedAutoBlockEntities;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.inventory.PackagingProviderItemHandler;
import thelm.packagedauto.item.PackagedAutoItems;
import thelm.packagedauto.menu.PackagingProviderMenu;
import thelm.packagedauto.util.MiscHelper;

public class PackagingProviderBlockEntity
extends BaseBlockEntity
implements ISettingsCloneable {
    public List<IPackageRecipeInfo> recipeList = new ArrayList<IPackageRecipeInfo>();
    public IPackagePattern currentPattern;
    public List<ItemStack> toSend = new ArrayList<ItemStack>();
    public Direction sendDirection;
    public boolean sendOrdered;
    public boolean powered = false;
    public boolean blocking = false;
    public boolean provideDirect = true;
    public boolean providePackaging = false;
    public boolean provideUnpackaging = false;

    public PackagingProviderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackagedAutoBlockEntities.PACKAGING_PROVIDER.get(), pos, state);
        this.setItemHandler(new PackagingProviderItemHandler(this));
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"block.packagedauto.packaging_provider");
    }

    @Override
    public String getConfigTypeName() {
        return "block.packagedauto.packaging_provider";
    }

    public void updatePowered() {
        if (this.level.getBestNeighborSignal(this.worldPosition) > 0 != this.powered) {
            this.powered = !this.powered;
            this.setChanged();
        }
    }

    public void changeBlockingMode() {
        this.blocking = !this.blocking;
        this.setChanged();
    }

    public void changeProvideType(Type type) {
        switch (type.ordinal()) {
            case 0: {
                boolean bl = this.provideDirect = !this.provideDirect;
                if (this.provideDirect && this.providePackaging && this.provideUnpackaging) {
                    this.provideUnpackaging = false;
                    this.providePackaging = false;
                }
                if (this.provideDirect || this.providePackaging || this.provideUnpackaging) break;
                this.provideUnpackaging = true;
                this.providePackaging = true;
                break;
            }
            case 1: {
                boolean bl = this.providePackaging = !this.providePackaging;
                if (this.provideDirect && this.providePackaging && this.provideUnpackaging) {
                    this.provideDirect = false;
                }
                if (this.provideDirect || this.providePackaging || this.provideUnpackaging) break;
                this.provideDirect = true;
                break;
            }
            case 2: {
                boolean bl = this.provideUnpackaging = !this.provideUnpackaging;
                if (this.provideDirect && this.providePackaging && this.provideUnpackaging) {
                    this.provideDirect = false;
                }
                if (this.provideDirect || this.providePackaging || this.provideUnpackaging) break;
                this.provideDirect = true;
            }
        }
        this.postPatternChange();
        this.setChanged();
    }

    public void postPatternChange() {
    }

    @Override
    public ISettingsCloneable.Result loadConfig(CompoundTag nbt, HolderLookup.Provider registries, Player player) {
        this.blocking = nbt.getBoolean("blocking");
        this.provideDirect = nbt.getBoolean("direct");
        this.providePackaging = nbt.getBoolean("packaging");
        this.provideUnpackaging = nbt.getBoolean("unpackaging");
        Component message = null;
        if (nbt.contains("recipes") && this.itemHandler.getStackInSlot(0).isEmpty()) {
            Inventory playerInventory = player.getInventory();
            for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
                ItemStack stack = playerInventory.getItem(i);
                if (stack.isEmpty() || !stack.is(PackagedAutoItems.RECIPE_HOLDER) || stack.has(PackagedAutoDataComponents.RECIPE_LIST)) continue;
                ItemStack stackCopy = stack.split(1);
                List<IPackageRecipeInfo> recipeList = MiscHelper.INSTANCE.loadRecipeList(nbt.getList("recipes", 10), registries);
                if (!recipeList.isEmpty()) {
                    DataComponentPatch patch = DataComponentPatch.builder().set((DataComponentType)PackagedAutoDataComponents.RECIPE_LIST.get(), recipeList).build();
                    stackCopy.applyComponents(patch);
                }
                this.itemHandler.setStackInSlot(0, stackCopy);
                break;
            }
        }
        if (message != null) {
            return ISettingsCloneable.Result.partial(message);
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(CompoundTag nbt, HolderLookup.Provider registries, Player player) {
        nbt.putBoolean("blocking", this.blocking);
        nbt.putBoolean("direct", this.provideDirect);
        nbt.putBoolean("packaging", this.providePackaging);
        nbt.putBoolean("unpackaging", this.provideUnpackaging);
        if (!this.recipeList.isEmpty()) {
            nbt.put("recipes", (Tag)MiscHelper.INSTANCE.saveRecipeList(new ListTag(), this.recipeList, registries));
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        CompoundTag tag;
        IPackageRecipeInfo recipe;
        super.loadAdditional(nbt, registries);
        this.blocking = nbt.getBoolean("blocking");
        this.provideDirect = nbt.getBoolean("direct");
        this.providePackaging = nbt.getBoolean("packaging");
        this.provideUnpackaging = nbt.getBoolean("unpackaging");
        this.powered = nbt.getBoolean("powered");
        if (nbt.contains("pattern") && (recipe = MiscHelper.INSTANCE.loadRecipe(tag = nbt.getCompound("pattern"), registries)) != null) {
            List<IPackagePattern> patterns = recipe.getPatterns();
            byte index = tag.getByte("index");
            if (index >= 0 && index < patterns.size()) {
                this.currentPattern = patterns.get(index);
            }
        }
        MiscHelper.INSTANCE.loadAllItems(nbt.getList("to_send", 10), this.toSend, registries);
        if (nbt.contains("send_direction")) {
            this.sendDirection = Direction.from3DDataValue((int)nbt.getByte("send_direction"));
        }
        this.sendOrdered = nbt.getBoolean("send_ordered");
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putBoolean("blocking", this.blocking);
        nbt.putBoolean("direct", this.provideDirect);
        nbt.putBoolean("packaging", this.providePackaging);
        nbt.putBoolean("unpackaging", this.provideUnpackaging);
        nbt.putBoolean("powered", this.powered);
        if (this.currentPattern != null) {
            CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), this.currentPattern.getRecipeInfo(), registries);
            tag.putByte("index", (byte)this.currentPattern.getIndex());
            nbt.put("pattern", (Tag)tag);
        }
        nbt.put("to_send", (Tag)MiscHelper.INSTANCE.saveAllItems(new ListTag(), this.toSend, registries));
        if (this.sendDirection != null) {
            nbt.putByte("send_irection", (byte)this.sendDirection.get3DDataValue());
        }
        nbt.putBoolean("send_ordered", this.sendOrdered);
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new PackagingProviderMenu(windowId, inventory, this);
    }

    public static enum Type {
        DIRECT,
        PACKAGING,
        UNPACKAGING;

        public static final IntFunction<Type> BY_ID;
        public static final StreamCodec<ByteBuf, Type> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

