/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.crafting;

import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.crafting.PackagedAutoRecipeSerializers;
import thelm.packagedauto.item.PackagedAutoItems;

public class RecipeHolderCloningRecipe
extends CustomRecipe {
    public RecipeHolderCloningRecipe(CraftingBookCategory category) {
        super(category);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)PackagedAutoRecipeSerializers.RECIPE_HOLDER_CLONING.get();
    }

    public boolean matches(CraftingInput input, Level level) {
        List template = null;
        int count = 0;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(PackagedAutoItems.RECIPE_HOLDER)) {
                if (template == null && stack.has(PackagedAutoDataComponents.RECIPE_LIST)) {
                    template = (List)stack.get(PackagedAutoDataComponents.RECIPE_LIST);
                }
                ++count;
                continue;
            }
            return false;
        }
        return template != null && count > 0;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registry) {
        List template = null;
        boolean clearing = false;
        int count = 0;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(PackagedAutoItems.RECIPE_HOLDER)) {
                if (stack.has(PackagedAutoDataComponents.RECIPE_LIST)) {
                    if (template == null) {
                        template = (List)stack.get(PackagedAutoDataComponents.RECIPE_LIST);
                    } else {
                        clearing = true;
                    }
                }
                ++count;
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (template != null && count > 0) {
            ItemStack result = PackagedAutoItems.RECIPE_HOLDER.toStack(count);
            if (!clearing && count > 1) {
                DataComponentPatch patch = DataComponentPatch.builder().set((DataComponentType)PackagedAutoDataComponents.RECIPE_LIST.get(), template).build();
                result.applyComponents(patch);
            }
            return result;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }
}

