/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedauto.client.screen.EncoderScreen;
import thelm.packagedauto.menu.EncoderMenu;
import thelm.packagedauto.packet.SetItemStackPacket;
import thelm.packagedauto.slot.FalseCopySlot;
import thelm.packagedauto.util.ApiImpl;
import thelm.packagedauto.util.MiscHelper;

public class EncoderGhostIngredientHandler
implements IGhostIngredientHandler<EncoderScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(EncoderScreen gui, ITypedIngredient<I> ingredient, boolean doStart) {
        ItemStack stack = EncoderGhostIngredientHandler.wrapStack(ingredient.getIngredient());
        if (!stack.isEmpty()) {
            return ((EncoderMenu)gui.menu).slots.stream().filter(s -> s instanceof FalseCopySlot).map(s -> new SlotTarget((Slot)s, EncoderGhostIngredientHandler.getSlotArea(gui, s))).toList();
        }
        return List.of();
    }

    public void onComplete() {
    }

    private static Rect2i getSlotArea(AbstractContainerScreen<?> gui, Slot slot) {
        return new Rect2i(gui.getGuiLeft() + slot.x, gui.getGuiTop() + slot.y, 16, 16);
    }

    private static ItemStack wrapStack(Object ingredient) {
        if (ingredient instanceof ItemStack) {
            ItemStack stack = (ItemStack)ingredient;
            return stack;
        }
        IVolumeType type = ApiImpl.INSTANCE.getVolumeType(ingredient.getClass());
        if (type != null) {
            return MiscHelper.INSTANCE.tryMakeVolumePackage(ingredient);
        }
        return ItemStack.EMPTY;
    }

    private record SlotTarget<I>(Slot slot, Rect2i area) implements IGhostIngredientHandler.Target<I>
    {
        public Rect2i getArea() {
            return this.area;
        }

        public void accept(I ingredient) {
            ItemStack stack = EncoderGhostIngredientHandler.wrapStack(ingredient);
            if (!stack.isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SetItemStackPacket(this.slot.index, stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

