/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import java.util.Optional;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import thelm.packagedauto.api.IFluidStackWrapper;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.slot.FalseCopyVolumeSlot;

public class FluidVolumeGuiHandler
implements IGuiContainerHandler<AbstractContainerScreen<?>> {
    private final IIngredientManager ingredientManager;

    public FluidVolumeGuiHandler(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(AbstractContainerScreen<?> containerScreen, double mouseX, double mouseY) {
        Slot slot = containerScreen.getSlotUnderMouse();
        if (slot instanceof FalseCopyVolumeSlot) {
            FalseCopyVolumeSlot volumeSlot = (FalseCopyVolumeSlot)slot;
            IVolumeStackWrapper volumeStack = volumeSlot.volumeInventory.getStackInSlot(volumeSlot.slotIndex);
            if (volumeStack instanceof IFluidStackWrapper) {
                IFluidStackWrapper fluidVolumeStack = (IFluidStackWrapper)volumeStack;
                return this.ingredientManager.createTypedIngredient((Object)fluidVolumeStack.getFluid()).map(ing -> new ClickableIngredient(ing, FluidVolumeGuiHandler.getSlotArea(containerScreen, (Slot)volumeSlot)));
            }
        }
        return Optional.empty();
    }

    private static Rect2i getSlotArea(AbstractContainerScreen<?> gui, Slot slot) {
        return new Rect2i(gui.getGuiLeft() + slot.x, gui.getGuiTop() + slot.y, 16, 16);
    }

    private record ClickableIngredient<T>(ITypedIngredient<T> ingredient, Rect2i area) implements IClickableIngredient<T>
    {
        public ITypedIngredient<T> getTypedIngredient() {
            return this.ingredient;
        }

        public Rect2i getArea() {
            return this.area;
        }
    }
}

