/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import com.google.common.primitives.Ints;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.block.entity.CraftingProxyBlockEntity;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.item.PackagedAutoItems;

public class CraftingProxyItemHandler
extends BaseItemHandler<CraftingProxyBlockEntity> {
    public CraftingProxyItemHandler(CraftingProxyBlockEntity blockEntity) {
        super(blockEntity, 1);
    }

    @Override
    protected void onContentsChanged(int slot) {
        this.loadMarker();
        super.onContentsChanged(slot);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.is(PackagedAutoItems.PROXY_MARKER);
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return (IItemHandlerModifiable)EmptyItemHandler.INSTANCE;
    }

    @Override
    public void load(CompoundTag nbt, HolderLookup.Provider registries) {
        super.load(nbt, registries);
        this.loadMarker();
    }

    public void loadMarker() {
        ItemStack stack = this.getStackInSlot(0);
        if (stack.has(PackagedAutoDataComponents.MARKER_POS)) {
            DirectionalGlobalPos pos = (DirectionalGlobalPos)stack.get(PackagedAutoDataComponents.MARKER_POS);
            if (pos == null) {
                ((CraftingProxyBlockEntity)this.blockEntity).target = null;
            } else if (((CraftingProxyBlockEntity)this.blockEntity).getLevel() != null && !((CraftingProxyBlockEntity)this.blockEntity).getLevel().dimension().equals(pos.dimension())) {
                ((CraftingProxyBlockEntity)this.blockEntity).target = null;
            } else {
                BlockPos dirVec = pos.blockPos().subtract((Vec3i)((CraftingProxyBlockEntity)this.blockEntity).getBlockPos());
                int dist = Ints.max((int[])new int[]{Math.abs(dirVec.getX()), Math.abs(dirVec.getY()), Math.abs(dirVec.getZ())});
                if (dist <= CraftingProxyBlockEntity.range) {
                    ((CraftingProxyBlockEntity)this.blockEntity).target = pos;
                }
            }
        } else {
            ((CraftingProxyBlockEntity)this.blockEntity).target = null;
        }
    }
}

